<?php

declare (strict_types=1);
namespace WPForms\Vendor\Square\Models\Builders;

use WPForms\Vendor\Core\Utils\CoreHelper;
use WPForms\Vendor\Square\Models\Money;
use WPForms\Vendor\Square\Models\OrderReturnDiscount;
/**
 * Builder for model OrderReturnDiscount
 *
 * @see OrderReturnDiscount
 */
class OrderReturnDiscountBuilder
{
    /**
     * @var OrderReturnDiscount
     */
    private $instance;
    private function __construct(OrderReturnDiscount $instance)
    {
        $this->instance = $instance;
    }
    /**
     * Initializes a new Order Return Discount Builder object.
     */
    public static function init() : self
    {
        return new self(new OrderReturnDiscount());
    }
    /**
     * Sets uid field.
     *
     * @param string|null $value
     */
    public function uid(?string $value) : self
    {
        $this->instance->setUid($value);
        return $this;
    }
    /**
     * Unsets uid field.
     */
    public function unsetUid() : self
    {
        $this->instance->unsetUid();
        return $this;
    }
    /**
     * Sets source discount uid field.
     *
     * @param string|null $value
     */
    public function sourceDiscountUid(?string $value) : self
    {
        $this->instance->setSourceDiscountUid($value);
        return $this;
    }
    /**
     * Unsets source discount uid field.
     */
    public function unsetSourceDiscountUid() : self
    {
        $this->instance->unsetSourceDiscountUid();
        return $this;
    }
    /**
     * Sets catalog object id field.
     *
     * @param string|null $value
     */
    public function catalogObjectId(?string $value) : self
    {
        $this->instance->setCatalogObjectId($value);
        return $this;
    }
    /**
     * Unsets catalog object id field.
     */
    public function unsetCatalogObjectId() : self
    {
        $this->instance->unsetCatalogObjectId();
        return $this;
    }
    /**
     * Sets catalog version field.
     *
     * @param int|null $value
     */
    public function catalogVersion(?int $value) : self
    {
        $this->instance->setCatalogVersion($value);
        return $this;
    }
    /**
     * Unsets catalog version field.
     */
    public function unsetCatalogVersion() : self
    {
        $this->instance->unsetCatalogVersion();
        return $this;
    }
    /**
     * Sets name field.
     *
     * @param string|null $value
     */
    public function name(?string $value) : self
    {
        $this->instance->setName($value);
        return $this;
    }
    /**
     * Unsets name field.
     */
    public function unsetName() : self
    {
        $this->instance->unsetName();
        return $this;
    }
    /**
     * Sets type field.
     *
     * @param string|null $value
     */
    public function type(?string $value) : self
    {
        $this->instance->setType($value);
        return $this;
    }
    /**
     * Sets percentage field.
     *
     * @param string|null $value
     */
    public function percentage(?string $value) : self
    {
        $this->instance->setPercentage($value);
        return $this;
    }
    /**
     * Unsets percentage field.
     */
    public function unsetPercentage() : self
    {
        $this->instance->unsetPercentage();
        return $this;
    }
    /**
     * Sets amount money field.
     *
     * @param Money|null $value
     */
    public function amountMoney(?Money $value) : self
    {
        $this->instance->setAmountMoney($value);
        return $this;
    }
    /**
     * Sets applied money field.
     *
     * @param Money|null $value
     */
    public function appliedMoney(?Money $value) : self
    {
        $this->instance->setAppliedMoney($value);
        return $this;
    }
    /**
     * Sets scope field.
     *
     * @param string|null $value
     */
    public function scope(?string $value) : self
    {
        $this->instance->setScope($value);
        return $this;
    }
    /**
     * Initializes a new Order Return Discount object.
     */
    public function build() : OrderReturnDiscount
    {
        return CoreHelper::clone($this->instance);
    }
}
