// JavaScript Document
$(document).on("ready", inicio());

function inicio() 
{

	$("#idFactura_nombre").keyup(valida_nombre);
	$("#idFactura_rfc").keyup(valida_rfc);
	$("#idFactura_email").keyup(valida_email);
	$("#idFactura_cfdi").change(valida_cfdi);
	
	$("#idFormSubmitSolicitarFactura").click(valida_nombre);
	$("#idFormSubmitSolicitarFactura").click(valida_rfc);
	$("#idFormSubmitSolicitarFactura").click(valida_email);
	$("#idFormSubmitSolicitarFactura").click(valida_cfdi);
}


/* ============================================================ */
function valida_nombre()
{
	var datos = document.getElementById("idFactura_nombre").value;

	if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
	{
		$("#idFactura_nombre").attr("class","form-control is-invalid");
		$("#idFactura_nombre").parent().children("div").text("Obligatorio").show();
  		return false;
	}
	else
	{
		$("#idFactura_nombre").attr("class","form-control is-valid");
		$("#idFactura_nombre").parent().children("div").text("Correcto").hide();
  		return true;
	}
}

/* ============================================================ */
function valida_rfc()
{
	var datos = document.getElementById("idFactura_rfc").value;
  var patron_rfc = /^[A-Za-zÑñ]{3,4}[\d]{6}([A-Za-z\d]{3})?$/;

	if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
	{
		$("#idFactura_rfc").attr("class","form-control is-invalid");
		$("#idFactura_rfc").parent().children("div").text("Obligatorio").show();
  	return false;
	}

  else if( !(patron_rfc.test(datos)) ) {
    $("#idFactura_rfc").attr("class","form-control is-invalid");
		$("#idFactura_rfc").parent().children("div").text("RFC incorrecto").show();
  	return false;
  }
	else
	{
		$("#idFactura_rfc").attr("class","form-control is-valid");
		$("#idFactura_rfc").parent().children("div").text("Correcto").hide();
  		return true;
	}
}

/* ============================================================ */
function valida_email()
{
	var datos = document.getElementById("idFactura_email").value;

	if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
	{
		$("#idFactura_email").attr("class","form-control is-invalid");
		$("#idFactura_email").parent().children("div").text("Obligatorio").show();
  		return false;
	}
  else if( !(/\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w/.test(datos)) )
  {
    $("#idFactura_email").attr("class","form-control  is-invalid");
    $("#idFactura_email").parent().children("div").text("El correo electrónico es inválido. Favor de verificarlo.").show();
    return false;
  }
	else
	{
		$("#idFactura_email").attr("class","form-control is-valid");
		$("#idFactura_email").parent().children("div").text("Correcto").hide();
  		return true;
	}
}


/* ============================================================ */
function valida_cfdi()
{
	var datos = document.getElementById("idFactura_cfdi").value;

	if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
	{
		$("#idFactura_cfdi").attr("class","form-control is-invalid");
		$("#idFactura_cfdi").parent().children("div").text("Obligatorio").show();
  		return false;
	}
	else
	{
		$("#idFactura_cfdi").attr("class","form-control is-valid");
		$("#idFactura_cfdi").parent().children("div").text("Correcto").hide();
  		return true;
	}
}


