// JavaScript Document
$(document).on("ready", inicio());

function inicio() 
{

	$("#idNombre").keyup(valida_nombre);
	$("#idApePat").keyup(valida_paterno);
	//$("#idApeMat").change(valida_materno);
	$("#idEmail1").keyup(valida_email1);
	$("#idEmal2").keyup(valida_email2);
	$("#idPsw1").keyup(valida_psw1);
	$("#idPsw2").keyup(valida_psw2);
	
	$("#idSubmitRegistrate").click(valida_nombre);
	$("#idSubmitRegistrate").click(valida_paterno);
	//$("#idSubmitRegistrate").click(valida_materno);
	$("#idSubmitRegistrate").click(valida_email1);
	$("#idSubmitRegistrate").click(valida_email2);
	$("#idSubmitRegistrate").click(valida_psw1);
	$("#idSubmitRegistrate").click(valida_psw2);
}



/* ============================================================ */
function valida_nombre()
{
	var nombre = document.getElementById("idNombre").value;

	if( nombre == null || nombre.length == 0 || /^\s+$/.test(nombre) )
	{
		$("#idNombre").attr("class","form-control is-invalid");
		$("#idNombre").parent().children("div").text("Obligatorio").show();
  		return false;
	}
	else
	{
		$("#idNombre").attr("class","form-control is-valid");
		$("#idNombre").parent().children("div").text("Correcto").hide();
  		return true;
	}
}

/* ============================================================ */
function valida_paterno()
{
	var paterno = document.getElementById("idApePat").value;

	if( paterno == null || paterno.length == 0 || /^\s+$/.test(paterno) )
	{
		$("#idApePat").attr("class","form-control is-invalid");
		$("#idApePat").parent().children("div").text("Obligatorio").show();
  		return false;
	}
	else
	{
		$("#idApePat").attr("class","form-control is-valid");
		$("#idApePat").parent().children("div").text("Correcto").hide();
  		return true;
	}
}

/* ============================================================ */
function valida_email1()
{
	var email1 = document.getElementById("idEmail1").value;

	if( email1 == null || email1.length == 0 || /^\s+$/.test(email1) )
	{
		$("#idEmail1").attr("class","form-control is-invalid");
		$("#idEmail1").parent().children("div").text("Obligatorio").show();
  	return false;
	}
  else if( !(/\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w/.test(email1)) )
  {
    $("#idEmail1").attr("class","form-control  is-invalid");
    $("#idEmail1").parent().children("div").text("El correo electrónico es inválido. Favor de verificarlo.").show();
    return false;
  }
	else
	{
		$("#idEmail1").attr("class","form-control is-valid");
		$("#idEmail1").parent().children("div").text("Correcto").hide();
  		return true;
	}
}

/* ============================================================ */
function valida_email2()
{
  var email1 = document.getElementById("idEmail1").value;
	var email2 = document.getElementById("idEmail2").value;

	if( email2 == null || email2.length == 0 || /^\s+$/.test(email2) )
	{
		$("#idEmail2").attr("class","form-control is-invalid");
		$("#idEmail2").parent().children("div").text("Obligatorio").show();
  		return false;
	}
  else if( !(/\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w/.test(email2)) )
  {
    $("#idEmail2").attr("class","form-control  is-invalid");
    $("#idEmail2").parent().children("div").text("El correo electrónico es inválido. Favor de verificarlo.").show();
    return false;
  }
  else if( email1 != email2)
  {
    $("#idEmail2").attr("class","form-control  is-invalid");
    $("#idEmail2").parent().children("div").text("Los correos no coinciden").show();
    return false;
  }
	else
	{
		$("#idEmail2").attr("class","form-control is-valid");
		$("#idEmail2").parent().children("div").text("Correcto").hide();
  		return true;
	}
}


/* ============================================================ */
function valida_psw1()
{
	var psw1 = document.getElementById("idPsw1").value;

	if( psw1 == null || psw1.length == 0 || /^\s+$/.test(psw1) )
	{
		$("#idPsw1").attr("class","form-control is-invalid");
		$("#idPsw1").parent().children("div").text("Obligatorio").show();
  		return false;
	}
  else if(psw1.length <= 7){
    $("#idPsw1").attr("class","form-control  is-invalid");
    $("#idPsw1").parent().children("div").text("Minimo 8 caracteres").show();
      return false;
  }
	else
	{
		$("#idPsw1").attr("class","form-control is-valid");
		$("#idPsw1").parent().children("div").text("Correcto").hide();
  		return true;
	}
}

/* ============================================================ */
function valida_psw2()
{
  var psw1 = document.getElementById("idPsw1").value;
	var psw2 = document.getElementById("idPsw2").value;

	if( psw2 == null || psw2.length == 0 || /^\s+$/.test(psw2) )
	{
		$("#idPsw2").attr("class","form-control is-invalid");
		$("#idPsw2").parent().children("div").text("Obligatorio").show();
  		return false;
	}
  else if(psw2.length <= 7){
    $("#idPsw2").attr("class","form-control  is-invalid");
    $("#idPsw2").parent().children("div").text("Minimo 8 caracteres").show();
      return false;
  }
  else if(psw1 != psw2){
    $("#idPsw2").attr("class","form-control  is-invalid");
    $("#idPsw2").parent().children("div").text("Las contraseñas no coinciden").show();
      return false;
  }
	else
	{
		$("#idPsw2").attr("class","form-control is-valid");
		$("#idPsw2").parent().children("div").text("Correcto").hide();
  		return true;
	}
}
