 // JavaScript Document
 $(document).on("ready", inicio());

 function inicio() 
 {
   $("#idInputProductoEdit_producto").keyup(valida_producto);
   $("#idInputProductoEdit_precio").keyup(valida_precio);
   $("#idInputProductoEdit_divisa").change(valida_divisa);
   $("#idInputProductoEdit_stock").keyup(valida_stock);
   $("#idInputProductoEdit_costo_envio").keyup(valida_costo_envio);
   
   $("#idSubmitProductoEdit").click(valida_producto);
   $("#idSubmitProductoEdit").click(valida_precio);
   $("#idSubmitProductoEdit").click(valida_divisa);
   $("#idSubmitProductoEdit").click(valida_stock);
   $("#idSubmitProductoEdit").click(valida_costo_envio);
 }
 
 function valida_producto()
 {
   var datos = document.getElementById("idInputProductoEdit_producto").value;
 
   if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
   {
     $("#idInputProductoEdit_producto").attr("class","form-control is-invalid");
     $("#idInputProductoEdit_producto").parent().children("div").text("Obligatorio").show();
       return false;
   }
   else
   {
     $("#idInputProductoEdit_producto").attr("class","form-control is-valid");
     $("#idInputProductoEdit_producto").parent().children("div").text("Correcto").hide();
       return true;
   }
 } 
 function valida_precio()
 {
   var datos = document.getElementById("idInputProductoEdit_precio").value;
 
   if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
   {
     $("#idInputProductoEdit_precio").attr("class","form-control is-invalid");
     $("#idInputProductoEdit_precio").parent().children("div").text("Obligatorio").show();
       return false;
   }
   else if(isNaN(datos))
   {
     $("#idInputProductoEdit_precio").attr("class","form-control is-invalid");
     $("#idInputProductoEdit_precio").parent().children("div").text("Solo valores numericos").show();
       return false;
   }
   else
   {
     $("#idInputProductoEdit_precio").attr("class","form-control is-valid");
     $("#idInputProductoEdit_precio").parent().children("div").text("Correcto").hide();
       return true;
   }
 }
 function valida_divisa()
 {
   var datos = document.getElementById("idInputProductoEdit_divisa").value;
 
   if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
   {
     $("#idInputProductoEdit_divisa").attr("class","form-control is-invalid");
     $("#idInputProductoEdit_divisa").parent().children("div").text("Obligatorio").show();
       return false;
   }
   else
   {
     $("#idInputProductoEdit_divisa").attr("class","form-control is-valid");
     $("#idInputProductoEdit_divisa").parent().children("div").text("Correcto").hide();
       return true;
   }
 }
 function valida_stock()
 {
   var datos = document.getElementById("idInputProductoEdit_stock").value;
 
   if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
   {
     $("#idInputProductoEdit_stock").attr("class","form-control is-invalid");
     $("#idInputProductoEdit_stock").parent().children("div").text("Obligatorio").show();
       return false;
   }
   else
   {
     $("#idInputProductoEdit_stock").attr("class","form-control is-valid");
     $("#idInputProductoEdit_stock").parent().children("div").text("Correcto").hide();
       return true;
   }
 }
 function valida_costo_envio()
 {
   var datos = document.getElementById("idInputProductoEdit_costo_envio").value;
 
   if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
   {
     $("#idInputProductoEdit_costo_envio").attr("class","form-control is-invalid");
     $("#idInputProductoEdit_costo_envio").parent().children("div").text("Obligatorio").show();
       return false;
   }
   else if(isNaN(datos))
   {
     $("#idInputProductoEdit_costo_envio").attr("class","form-control is-invalid");
     $("#idInputProductoEdit_costo_envio").parent().children("div").text("Solo valores numericos").show();
       return false;
   }
   else
   {
     $("#idInputProductoEdit_costo_envio").attr("class","form-control is-valid");
     $("#idInputProductoEdit_costo_envio").parent().children("div").text("Correcto").hide();
       return true;
   }
 }
 