 // JavaScript Document
$(document).on("ready", inicio());

function inicio() 
{
	$("#idInputProductoAdd_producto").keyup(valida_producto);
	$("#idInputProductoAdd_precio").keyup(valida_precio);
	$("#idInputProductoAdd_divisa").change(valida_divisa);
	$("#idInputProductoAdd_stock").keyup(valida_stock);
	$("#idInputProductoAdd_costo_envio").keyup(valida_costo_envio);
	
	$("#idSubmitProductoAdd").click(valida_producto);
	$("#idSubmitProductoAdd").click(valida_precio);
	$("#idSubmitProductoAdd").click(valida_divisa);
	$("#idSubmitProductoAdd").click(valida_stock);
	$("#idSubmitProductoAdd").click(valida_costo_envio);
}

function valida_producto()
{
	var datos = document.getElementById("idInputProductoAdd_producto").value;

	if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
	{
		$("#idInputProductoAdd_producto").attr("class","form-control is-invalid");
		$("#idInputProductoAdd_producto").parent().children("div").text("Obligatorio").show();
  		return false;
	}
	else
	{
		$("#idInputProductoAdd_producto").attr("class","form-control is-valid");
		$("#idInputProductoAdd_producto").parent().children("div").text("Correcto").hide();
  		return true;
	}
}
function valida_precio()
{
	var datos = document.getElementById("idInputProductoAdd_precio").value;

	if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
	{
		$("#idInputProductoAdd_precio").attr("class","form-control is-invalid");
		$("#idInputProductoAdd_precio").parent().children("div").text("Obligatorio").show();
  		return false;
	}
  else if(isNaN(datos))
	{
		$("#idInputProductoAdd_precio").attr("class","form-control is-invalid");
		$("#idInputProductoAdd_precio").parent().children("div").text("Solo valores numericos").show();
  		return false;
	}
	else
	{
		$("#idInputProductoAdd_precio").attr("class","form-control is-valid");
		$("#idInputProductoAdd_precio").parent().children("div").text("Correcto").hide();
  		return true;
	}
}
function valida_divisa()
{
	var datos = document.getElementById("idInputProductoAdd_divisa").value;

	if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
	{
		$("#idInputProductoAdd_divisa").attr("class","form-control is-invalid");
		$("#idInputProductoAdd_divisa").parent().children("div").text("Obligatorio").show();
  		return false;
	}
	else
	{
		$("#idInputProductoAdd_divisa").attr("class","form-control is-valid");
		$("#idInputProductoAdd_divisa").parent().children("div").text("Correcto").hide();
  		return true;
	}
}
function valida_stock()
{
	var datos = document.getElementById("idInputProductoAdd_stock").value;

	if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
	{
		$("#idInputProductoAdd_stock").attr("class","form-control is-invalid");
		$("#idInputProductoAdd_stock").parent().children("div").text("Obligatorio").show();
  		return false;
	}
	else
	{
		$("#idInputProductoAdd_stock").attr("class","form-control is-valid");
		$("#idInputProductoAdd_stock").parent().children("div").text("Correcto").hide();
  		return true;
	}
}
function valida_costo_envio()
 {
   var datos = document.getElementById("idInputProductoAdd_costo_envio").value;
 
   if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
   {
     $("#idInputProductoAdd_costo_envio").attr("class","form-control is-invalid");
     $("#idInputProductoAdd_costo_envio").parent().children("div").text("Obligatorio").show();
       return false;
   }
   else if(isNaN(datos))
   {
     $("#idInputProductoAdd_costo_envio").attr("class","form-control is-invalid");
     $("#idInputProductoAdd_costo_envio").parent().children("div").text("Solo valores numericos").show();
       return false;
   }
   else
   {
     $("#idInputProductoAdd_costo_envio").attr("class","form-control is-valid");
     $("#idInputProductoAdd_costo_envio").parent().children("div").text("Correcto").hide();
       return true;
   }
 }
 