// JavaScript Document
$(document).on("ready", inicio());

function inicio() 
{
	$("#idInputPaqueteEdit_costo").keyup(valida_costo);
	$("#idInputPaqueteEdit_nombre").keyup(valida_nombre);

	$("#idSubmitPaqueteEdit").click(valida_costo);
	$("#idSubmitPaqueteEdit").click(valida_nombre);
}



/* ============================================================ */
function valida_costo()
{
	var datos = document.getElementById("idInputPaqueteEdit_costo").value;

	if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
	{
		$("#idInputPaqueteEdit_costo").attr("class","form-control is-invalid");
		$("#idInputPaqueteEdit_costo").parent().children("div").text("Obligatorio").show();
  		return false;
	}
  else if( isNaN(datos) ) {
    $("#idInputPaqueteEdit_costo").attr("class","form-control  is-invalid");
    $("#idInputPaqueteEdit_costo").parent().children("div").text("Solo valores numéricos").show();
      return false;
  }
	else
	{
		$("#idInputPaqueteEdit_costo").attr("class","form-control is-valid");
		$("#idInputPaqueteEdit_costo").parent().children("div").text("Correcto").hide();
  		return true;
	}
}


/* ============================================================ */
function valida_nombre()
{
	var datos = document.getElementById("idInputPaqueteEdit_nombre").value;

	if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
	{
		$("#idInputPaqueteEdit_nombre").attr("class","form-control is-invalid");
		$("#idInputPaqueteEdit_nombre").parent().children("div").text("Obligatorio").show();
  		return false;
	}
	else
	{
		$("#idInputPaqueteEdit_nombre").attr("class","form-control is-valid");
		$("#idInputPaqueteEdit_nombre").parent().children("div").text("Correcto").hide();
  		return true;
	}
}
