// JavaScript Document
$(document).on("ready", inicio());

function inicio() 
{
	$("#idInputPaqueteAdd_costo").keyup(valida_costo);
	$("#idInputPaqueteAdd_nombre").keyup(valida_nombre);

	$("#idSubmitPaqueteAdd").click(valida_costo);
	$("#idSubmitPaqueteAdd").click(valida_nombre);
}



/* ============================================================ */
function valida_costo()
{
	var datos = document.getElementById("idInputPaqueteAdd_costo").value;

	if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
	{
		$("#idInputPaqueteAdd_costo").attr("class","form-control is-invalid");
		$("#idInputPaqueteAdd_costo").parent().children("div").text("Obligatorio").show();
  		return false;
	}
  else if( isNaN(datos) ) {
    $("#idInputPaqueteAdd_costo").attr("class","form-control  is-invalid");
    $("#idInputPaqueteAdd_costo").parent().children("div").text("Solo valores numéricos").show();
      return false;
  }
	else
	{
		$("#idInputPaqueteAdd_costo").attr("class","form-control is-valid");
		$("#idInputPaqueteAdd_costo").parent().children("div").text("Correcto").hide();
  		return true;
	}
}


/* ============================================================ */
function valida_nombre()
{
	var datos = document.getElementById("idInputPaqueteAdd_nombre").value;

	if( datos == null || datos.length == 0 || /^\s+$/.test(datos) )
	{
		$("#idInputPaqueteAdd_nombre").attr("class","form-control is-invalid");
		$("#idInputPaqueteAdd_nombre").parent().children("div").text("Obligatorio").show();
  		return false;
	}
	else
	{
		$("#idInputPaqueteAdd_nombre").attr("class","form-control is-valid");
		$("#idInputPaqueteAdd_nombre").parent().children("div").text("Correcto").hide();
  		return true;
	}
}
