<?php
  if (!isset($_SESSION)) {
    session_start();
  }

  include_once('../variables-globales.php');
	include_once("../Connections/conexion.php");

	//==================================================
	if (!function_exists("GetSQLValueString"))
	{
		function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "")
		{
			switch ($theType)
			{
				case "text":
					$theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
					break;
				case "long":
				case "int":
					$theValue = ($theValue != "") ? intval($theValue) : "NULL";
					break;
				case "double":
					$theValue = ($theValue != "") ? doubleval($theValue) : "NULL";
					break;
				case "date":
					$theValue = ($theValue != "") ? "'" . $theValue . "'" : "NULL";
					break;
				case "defined":
					$theValue = ($theValue != "") ? $theDefinedValue : $theNotDefinedValue;
					break;
			}
			return $theValue;
		}
	}
	//==================================================================


  if (isset($_POST['usr']))
  {
    $loginUsername = $_POST['usr'];
    $password = md5($_POST['psw']);

    $_SESSION['email_log'] = $loginUsername;

    mysqli_select_db($conexion, $database_conexion);
    $sql = sprintf("SELECT
    g13_usuarios.id,
    g13_usuarios.id_nivel,
    g13_usuarios.img,
    g13_usuarios.usr,
    g13_usuarios.psw,
    g13_usuarios.nombre,
    g13_usuarios.apepat,
    g13_usuarios.apemat,
    g13_usuarios.calle,
    g13_usuarios.colonia,
    g13_usuarios.id_pais,
    g13_catalogos_2.nombre AS nombre_pais,
    g13_usuarios.id_estado,
    g13_catalogos_3.nombre as nombre_estado,
    g13_usuarios.mpio,
    g13_usuarios.cp,
    g13_usuarios.fecha_nacimiento,
    g13_usuarios.dato_1,
    g13_usuarios.dato_2,
    g13_usuarios.estatus,
    g13_usuarios.fecha_hora,
    g13_usuarios_nivel.id AS nivel_id,
    g13_usuarios_nivel.nombre AS nivel_nombre,
    g13_usuarios_nivel.descripcion AS nivel_descripcion
    FROM
    g13_usuarios
    LEFT JOIN g13_usuarios_nivel ON g13_usuarios.id_nivel = g13_usuarios_nivel.id
    LEFT JOIN g13_catalogos_2 ON g13_usuarios.id_pais = g13_catalogos_2.id
    LEFT JOIN g13_catalogos_3 ON g13_usuarios.id_estado = g13_catalogos_3.id
    WHERE g13_usuarios.usr = %s
    AND g13_usuarios.psw = %s
    AND g13_usuarios.estatus = %s",
    GetSQLValueString($loginUsername, "text"),
    GetSQLValueString($password, "text"),
    GetSQLValueString(1, "tinyint"));
    $Usuario = mysqli_query($conexion, $sql) or die(mysqli_error());
    $row_Usuario = mysqli_fetch_assoc($Usuario);
    $totalRows_Usuario = mysqli_num_rows($Usuario);

    $arrayDatos = [];
    if($totalRows_Usuario > 0) {
      //genera la variable sesion con los datos del usuario
      $_SESSION[$nameSesion] = $row_Usuario;

      /*mmmmmmmmmmmm inicio de inserta el usuario que se conecto mmmmmmmmmmmmmmmmmmmmmmmm*/
      $insertSQL = sprintf("INSERT INTO g13_bitacora_login (id_usr, fecha_hora) VALUES (%s, %s)",
      GetSQLValueString($row_Usuario['id'], "int"),
      GetSQLValueString(date("Y-m-d H:i:s"), "date"));
      mysqli_select_db($conexion, $database_conexion);
      $Result1 = mysqli_query($conexion, $insertSQL) or die(mysqli_error());
      /*mmmmmmmmmmmm fin de inserta el usuario que se conecto mmmmmmmmmmmmmmmmmmmmmmmm*/

      array_push($arrayDatos,
        [
          'usuario'         => $row_Usuario,
          'sesion_estatus'  => 1
        ]
      );
    } else {
      array_push($arrayDatos,
        [
          'usuario'         => null,
          'sesion_estatus'  => 0
        ]
      );
    }
  }

  $jsonString = json_encode($arrayDatos);
  echo $jsonString;
