$(function(){

  $(function () {
    $('[data-toggle="tooltip"]').tooltip()
  })


  //console.log('usuarios is running...');
  nivelesUsuariosList();

  $('#idFormUsuariosNivelNuevo').submit(function(e){
    e.preventDefault();
    let nombre      = $('#idInputUsuarioNivel_nombre').val();
    let descripcion = $('#idInputUsuarioNivel_descripcion').val();
    //console.log(nombre, descripcion);

    nivelesUsuariosAdd(nombre, descripcion);
  });
  $('#idFormUsuariosNivelEdita').submit(function(e){
    e.preventDefault();
    let id      = $('#idInputUsuarioNivelEdita_id').val();
    let nombre      = $('#idInputUsuarioNivelEdita_nombre').val();
    let descripcion = $('#idInputUsuarioNivelEdita_descripcion').val();
    //console.log(id, nombre, descripcion);

    nivelesUsuariosEdit(id, nombre, descripcion);
  });
  //Form nuevo usuario
  $('#idFormtUsrAdd').submit(function(e){
    e.preventDefault();
    let idNivel = $('#idInputUsrAdd_nivel').val();

    let img     = 'sin-img.jpg';
    let usr     = $('#idInputUsrAdd_usr').val();
    let psw     = $('#idInputUsrAdd_psw').val();
    let nombre  = $('#idInputUsrAdd_nombre').val();
    let apepat  = $('#idInputUsrAdd_apepat').val();
    let apemat  = $('#idInputUsrAdd_apemat').val();

    let calle       = $('#idInputUsrAdd_calle').val();
    let colonia     = $('#idInputUsrAdd_colonia').val();
    let cp          = $('#idInputUsrAdd_cp').val();
    let id_pais     = $('#idInputUsrAdd_pais').val();
    let id_estado   = $('#idInputUsrAdd_estado').val();
    let mpio        = $('#idInputUsrAdd_mpio').val();

    let fecha_nacimiento  = $('#idInputUsrAdd_fecha_nacimiento').val();
    let dato_1            = $('#idInputUsrAdd_dato_1').val();
    let dato_2            = $('#idInputUsrAdd_dato_2').val();
    let cv                = ckeUsuarioCV.getData();
    let estatus           = 1;
    console.log(idNivel, img, usr, psw, nombre, apepat, apemat, calle, colonia, cp, id_pais, id_estado, mpio, fecha_nacimiento, dato_1, dato_2, cv, estatus);

    usuariosAdd(idNivel, img, usr, psw, nombre, apepat, apemat, calle, colonia, cp, id_pais, id_estado, mpio, fecha_nacimiento, dato_1, dato_2, cv, estatus);
  });
  //Form edita usuario
  $('#idFormtUsrEdit').submit(function(e){
    e.preventDefault();
    let id      = $('#idInputUsrEdit_id').val();
    let idNivel = $('#idInputUsrEdit_nivel').val();
    let gerente = $('#idInputUsrEdit_gerente').val();
    var comboNivel = document.getElementById("idInputUsrEdit_nivel");
    var nameNivel = comboNivel.options[comboNivel.selectedIndex].text;

    let usr     = $('#idInputUsrEdit_usr').val();
    //let psw     = $('#idInputUsrEdit_psw').val();
    let nombre  = $('#idInputUsrEdit_nombre').val();
    let apepat  = $('#idInputUsrEdit_apepat').val();
    let apemat  = $('#idInputUsrEdit_apemat').val();

    let calle       = $('#idInputUsrEdit_calle').val();
    let colonia     = $('#idInputUsrEdit_colonia').val();
    let cp          = $('#idInputUsrEdit_cp').val();
    let id_pais     = $('#idInputUsrEdit_pais').val();
    let id_estado   = $('#idInputUsrEdit_estado').val();
    let mpio        = $('#idInputUsrEdit_mpio').val();

    let fecha_nacimiento  = $('#idInputUsrEdit_fecha_nacimiento').val();
    let dato_1            = $('#idInputUsrEdit_dato_1').val();
    let dato_2            = $('#idInputUsrEdit_dato_2').val();
    let cv                = ckeUsuarioCVEdit.getData();
    //console.log(id, idNivel, usr, psw, nombre, apepat, apemat, calle, colonia, cp, id_pais, id_estado, mpio, fecha_nacimiento, dato_1, dato_2);

    editUser(id, idNivel, gerente, nameNivel, usr, nombre, apepat, apemat, calle, colonia, cp, id_pais, id_estado, mpio, fecha_nacimiento, dato_1, dato_2, cv);
  });
  //Forma de contacto ADD
  $('#idFormUsrContactoAdd').submit(function(e){
    e.preventDefault();
    let idUsr       = $('#idInputUsrContactoAdd_idUsr').val();
    let dato_1      = $('#idInputUsrContactoAdd_dato_1').val();
    let idNivel     = $('#idInputUsrContactoAdd_tipo').val();
    let descripcion = $('#idInputUsrContactoAdd_descripcion').val();
    let publico     = $('#idInputUsrContactoAdd_publico').val();
    let prioridad     = $('#idInputUsrContactoAdd_prioridad').val();
    //console.log(idUsr, idNivel, descripcion);

    formasContactoAdd(idUsr, dato_1, idNivel, descripcion, publico, prioridad);
  });
  //Forma de contacto EDIT
  $('#idFormUsrContactoEdit').submit(function(e){
    e.preventDefault();
    let id          = $('#idInputUsrContactoEdit_id').val();
    let dato_1      = $('#idInputUsrContactoEdit_dato_1').val();
    let idUsr       = $('#idInputUsrContactoEdit_id_usuario').val();
    let idNivel     = $('#idInputUsrContactoEdit_tipo').val();
    let descripcion = $('#idInputUsrContactoEdit_descripcion').val();
    let publico     = $('#idInputUsrContactoEdit_publico').val();
    let prioridad   = $('#idInputUsrContactoEdit_prioridad').val();
    //console.log(idUsr, idNivel, descripcion);

    formasContactoEdit(id, dato_1, idUsr, idNivel, descripcion, publico, prioridad);
  });

  //Forma usuario edita img perfil
  $('#idFormUsrImgPerfil').submit(function(e){
    e.preventDefault();

    let id           = $('#idInputUsrIdPerfil').val();
    let imgPerfil    = $('#idInputUsrImgPerfil')[0].files[0];
    //console.log(imgPerfil);
    
    var formData = new FormData();
    formData.append('id', id);
    formData.append('imgPerfil', imgPerfil);

    changePictureProfile(id, formData);

  });
  //Forma usuario edita img perfil
  $('#idFormEditPsw').submit(function(e){
    e.preventDefault();
    let newPsw  = $('#idInputEditPsw_psw').val();
    let idUsr   = $('#idInputEditPsw_id').val();

    changePassword(newPsw, idUsr);

  });
  //categoria por nivel add
  $('#idFormUN').submit(function(e){
    e.preventDefault();
    let id_nivel_usuario = $('#idInputUN_id_nivel_usuario').val();
    let categoria = $('#idInputUN_categoria').val();
    //console.log(id_nivel_usuario, categoria);
    nivel_categoria_add(id_nivel_usuario, categoria);
  });
  //categoria por nivel edit
  $('#idFormUNCatEdit').submit(function(e){
    e.preventDefault();
    let id_nivel_usuario = $('#idInputUNCatEdit_id_nivel_usr').val();
    let id = $('#idInputUNCatEdit_id').val();
    let categoria = $('#idInputUNCatEdit_categoria').val();
    //console.log(id_nivel_usuario, categoria);
    nivel_categoria_edit(id_nivel_usuario, id, categoria);
  });
  //categorias por nivel
  $('#idFormMisCategorias').submit(function(e){
    e.preventDefault();

    let id_usuario = $('#id_usuario').val();
    let elements = document.getElementsByName("arrayNivelCategorias[]");
    let arraySeleccionados = [];
    for(k=0; k<elements.length; k++)
    {
      if(elements[k].checked == true){
        arraySeleccionados.push(elements[k].value);
      }
    } 
    //console.log(arraySeleccionados);
    categorias_nivel_add(id_usuario, arraySeleccionados);
  });
  //permiso de contenido por nivel
  $('#idFormNivelesPermisos').submit(function(e){
    e.preventDefault();

    let id_nivel = $('#idInputNivelesPermisos_id_nivel').val();
    let elements = document.getElementsByName("arrayNivelesAllow[]");
    let arraySeleccionados = [];
    for(k=0; k<elements.length; k++)
    {
      if(elements[k].checked == true){
        arraySeleccionados.push(elements[k].value);
      }
    } 
    //console.log(arraySeleccionados);
    contenido_allow_add(id_nivel, arraySeleccionados);
  })

  usuariosList();
  catalogo_contacto(0, '---', 'idInputUsrContactoAdd_tipo');
  //18 id pagina usuarios.html en la tabla g13_paginas
  allowCrud(18);
  catalogo_paises();

  // ======== CV USUARIO ADD
  ClassicEditor
  .create(document.querySelector( '#idInputUsrAdd_cv'))
  .then(newEditor => { ckeUsuarioCV = newEditor; })
  .catch(error => { console.error(error); });
  // ======== CV USUARIO EDIT
  ClassicEditor
  .create(document.querySelector( '#idInputUsrEdit_cv'))
  .then(newEditor => { ckeUsuarioCVEdit = newEditor; })
  .catch(error => { console.error(error); });

});

function allowCrud(idPagina) {
  //console.log(idPagina);
  $.ajax({
    url : 'BackEnd/Permisos/crud-allow.php',
    data : {'idPagina' : idPagina},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos[0]['sesion']);

      // BOTON ADD - NIVEL
      let templete = ``;
      if(datos[0]['crud_pagina']['altas'] == 1) {
        templete = `
          <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#idModalUsuariosNuevoNivel">
            <i class="fas fa-plus"></i> Nuevo nivel
          </button>`;
      }   
      $('#idDivUsr_addNivel').html(templete);

      // BOTON NIVELES - USUARIO
      let templete1 = ``;
      if(datos[0]['sesion']['id_nivel'] == 1) {
        templete1 = `
        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#idModalUsuariosNiveles">
          Niveles
        </button>`;
      } 
      $('#idDivUsr_Niveles').html(templete1);


      // BOTON ADD - USUARIO
      let templete2 = ``;
      if(datos[0]['crud_pagina']['altas'] == 1) {
        templete2 = `
          <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#idModalUsuarioNuevo">
            <i class="fas fa-plus"></i> Nuevo usuario
          </button>`;
      } 
      $('#idDivUsr_add').html(templete2);

      // BOTON ADD - FORMA DE CONTACTO
      let templete3 = ``;
      if(datos[0]['crud_pagina']['altas'] == 1) {
        templete3 = `
          <button 
            type="button" 
            class="btn btn-outline-primary btn-sm"
            data-toggle="modal" 
            data-target="#idModalUsrContactoAdd">
            <i class="fas fa-plus"></i> Agregar
          </button>`;
      } 
      $('#idDivUsr_addFC').html(templete3);


    },
    error : function(error){
      console.log(error);
    }
  });
}
function formasContactoList(id, dato_1) { 
  //console.log(dato_1);
  $.ajax({
    url : 'BackEnd/Usuarios/contacto-list.php',
    data : {'id' : id},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos);

      $('#idInputUsrContactoAdd_idUsr').val(id);
      $('#idInputUsrContactoAdd_dato_1').val(dato_1);
      $('#idModalUsrFormasContactoUsr').html('Formas de contacte <b>'+dato_1+'</b>');

      let templete = ``;
      let cont = 1;

      datos.forEach(elemento => {
        //console.log(elemento['crud'][0]['crud_pagina']['bajas']);
        templete += `
        <tr>
          <th>${cont}</th>
          <td>${elemento['tipo']['icono_fa']} ${elemento['tipo']['nombre']}</td>
          <td>${elemento['contacto']['descripcion']}</td>
          <td>${(elemento['contacto']['publico'] == 1) ? 'Si' : 'No'}</td>
          <td>${elemento['contacto']['prioridad']}</td>`;

          templete += `
            <td>
              <button 
                type="button" 
                class="btn btn-outline-warning btn-sm"
                onclick="modalFormasContactoEdit(${elemento['contacto']['id']}, ${elemento['contacto']['id_usr']}, '${dato_1}')">
                <i class="far fa-edit"></i>
                </button>
            </td>`;

        
          //BAJAS
          if(elemento['crud'][0]['crud_pagina']['bajas'] == 1){
            templete += `
            <td>
              <button 
                type="button" 
                class="btn btn-outline-danger btn-sm"
                onclick="formasContactoDelete(${elemento['contacto']['id']}, ${elemento['contacto']['id_usr']}, '${dato_1}')">
                  <i class="far fa-trash-alt"></i>
                </button>
            </td>`;
          } else {
            templete += `
            <td>
            </td>`;
          }

          

        templete += `
        </tr>
        `;
        cont++;
      });

      $('#idTableBodyUsrContacto').html(templete);
    },
    error : function(error) {
      console.log(error);
    }
  });
}
function modalFormasContactoEdit(id, id_usuario, dato_1){

  
  $.ajax({
    url : 'BackEnd/Usuarios/contacto-list.php',
    data : {
      'id' : id_usuario,
      'id_registro' : id,
    },
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);


      $('#idModalUsrContactoEdit').modal('show');
      $('#idInputUsrContactoEdit_id').val(id);
      $('#idInputUsrContactoEdit_dato_1').val(dato_1);
      $('#idInputUsrContactoEdit_id_usuario').val(id_usuario);
      catalogo_contacto(datos[0]['tipo']['id'], datos[0]['tipo']['nombre'], 'idInputUsrContactoEdit_tipo')
      $('#idInputUsrContactoEdit_descripcion').val(datos[0]['contacto']['descripcion']);

      let templetePublico = ` 
          <option value="${datos[0]['contacto']['publico']}">
            ${(datos[0]['contacto']['publico'] == 1) ? 'Si' : 'No'}
          </option>
          ${((datos[0]['contacto']['publico'] == 1)) ? '<option value="0">No</option>' : '<option value="1">Si</option>'}
        `;
      
      $('#idInputUsrContactoEdit_publico').html(templetePublico);
      $('#idInputUsrContactoEdit_prioridad').val(datos[0]['contacto']['prioridad']);

      

    },
    error : function(error){
      console.log(error);
    }
  });
  
  
}


function formasContactoAdd(idUsr, dato_1, idNivel, descripcion, publico, prioridad){
  //console.log(idUsr, idNivel, descripcion, publico);
  $.ajax({
    url : 'BackEnd/Usuarios/contacto-add.php',
    data : {
      'idUsr'       : idUsr,
      'dato_1'      : dato_1,
      'idNivel'     : idNivel,
      'descripcion' : descripcion,
      'publico'     : publico,
      'prioridad'   : prioridad
    },
    type : 'POST',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos[0]);

      $('#idModalUsrContactoAdd').modal('hide');
      $('#idFormUsrContactoAdd').trigger('reset');

      Swal.fire(
        'Listo',
        'Forma de contacto agregada',
        'success'
      )

      formasContactoList(idUsr, dato_1);

    },
    error : function(error){
      console.log(error);
    }
  });
}
function formasContactoEdit(id, dato_1, idUsr, idNivel, descripcion, publico, prioridad){
  //console.log(idUsr, idNivel, descripcion, publico);
  $.ajax({
    url : 'BackEnd/Usuarios/contacto-edit.php',
    data : {
      'id'       : id,
      'idUsr'       : idUsr,
      'idNivel'     : idNivel,
      'descripcion' : descripcion,
      'publico'     : publico,
      'prioridad'   : prioridad
    },
    type : 'POST',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos[0]);

      $('#idModalUsrContactoEdit').modal('hide');
      $('#idFormUsrContactoEdit').trigger('reset');

      Swal.fire(
        'Listo',
        'Forma de contacto editada',
        'success'
      )

      formasContactoList(idUsr, dato_1);

    },
    error : function(error){
      console.log(error);
    }
  });
}



function formasContactoDelete(id, idUsr, dato_1) {
  //console.log(id, idUsr);

  Swal.fire({
    title: '¿Estas seguro?',
    text: "¡No podrás revertir esto!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: '¡Si, borrarlo!'
  }).then((result) => {
    if (result.isConfirmed) {

      $.ajax({
        url : 'BackEnd/Usuarios/contacto-delete.php',
        data : {
          'id'      : id,
          'idUsr'   : idUsr
        },
        type : 'POST',
        success : function(response) {
          //console.log(response);
    
          Swal.fire(
            'Listo',
            'Forma de contacto eliminada',
            'success'
          )
          formasContactoList(idUsr, dato_1);
        },
        error : function(error){
          console.log(error);
        }
      });

      
    }
  })

}
function catalogo_contacto(valor, contenido, idInput) {
  $.ajax({
    url : 'BackEnd/Catalogo_2/list.php',
    data : {'idCatalogo1' : 2},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos);

      let templete = `<option value="${valor}">${contenido}</option>`;
      datos.forEach(elemento => {
        templete += `
        <option value="${elemento['elemento']['id']}">${elemento['elemento']['nombre']}</option>
        `;
      });
      $('#'+idInput).html(templete);
    },
    error : function(error){
      console.log(error);
    }
  });
}
function nivelesUsuariosList(){
  $.ajax({
    url : 'BackEnd/Usuarios/nivelesList.php',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      //Inicio - Muestra en una tabla la lista de los niveles de usuarios
      let templete = ``;
      let cont = 1;
      datos.forEach(nivel => {
        templete += `
        <tr>
          <th>${cont}</th>
          <td>${nivel['nivel']['nombre']}</td>
          <td>${nivel['nivel']['descripcion']}</td>
          <td style="width: 5%;">
            <button 
              type="button" 
              class="btn btn-outline-warning btn-sm"
              data-toggle="modal" 
              data-target="#idModalUsuarioseEditaNivel"
              onclick="nivelesUsuariosModalEdit(${nivel['nivel']['id']})">
              <i class="far fa-edit"></i>
            </button>
          </td>`;

          let colorBtn = 'danger';
          let textoBtn = '<i class="fas fa-exclamation-triangle"></i>';
          if(nivel['categorias'].length > 0) {
            colorBtn = 'success';
            textoBtn = '<i class="fas fa-user-tag"></i>';
          }

          

          templete += `
          <td style="width: 5%;">
            <button 
              type="button" 
              class="btn btn-outline-info btn-sm"
              onclick="contenido_allow_list(${nivel['nivel']['id']}, '${nivel['nivel']['nombre']}')">
                <i class="fas fa-user-lock"></i>
              </button>
          </td>
          `;

          templete += `
          <td style="width: 5%;">
            <button 
              type="button" 
              class="btn btn-outline-${colorBtn} btn-sm"
              onclick="nivel_categoria_modal(${nivel['nivel']['id']}, '${nivel['nivel']['nombre']}')">
              ${textoBtn}
            </button>
          </td>
          `;

        templete += `
        </tr>
        `;
        cont++;
      });
      $('#idTableBodyUsuariosNiveles').html(templete);
      //Fin - Muestra en una tabla la lista de los niveles de usuarios


      //Inicio - Muestra en lista para agregar un nuevo usuario
      let templeteList = `<option value="">---</option>`;
      //console.log(datos);
      datos.forEach(nivelList => {
        if(nivelList['nivel']['id'] > 1){
          templeteList += `
            <option value="${nivelList['nivel']['id']}">${nivelList['nivel']['nombre']}</option>
          `;
          cont++;
        }
      });
      $('#idInputUsrAdd_nivel').html(templeteList);
      //Inicio - Muestra en lista para agregar un nuevo usuario


      //Inicio - Muestra en lista para editar usuario
      let eu_nivelId    = localStorage.getItem('id_nivel');
      let eu_nivelName  = localStorage.getItem('usrEdit_nivelNombre'); 
      
      let templeteList2 = `<option value="${eu_nivelId}">${eu_nivelName}</option>`;
      datos.forEach(nivelList => {
        if(nivelList['nivel']['id'] > 1){
          templeteList2 += `
            <option value="${nivelList['nivel']['id']}">${nivelList['nivel']['nombre']}</option>
          `;
          cont++;
        }
      });
      $('#idInputUsrEdit_nivel').html(templeteList2);
      //Fin - Muestra en lista para editar usuario

    },
    error : function(error){
      console.log(error);
    }
  });
}
function contenido_allow_list(nivel_id, nivel_nombre){
  $.ajax({
    url : 'BackEnd/Nivel_1/contenido_permitido_list.php',
    data : {
      'idN1' : nivel_id
    },
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      $('#idModalNivelesPermisos').modal('show');
      $('#idInputNivelesPermisos_id_nivel').val(nivel_id);
      $('#idModalTitleNivelesPermisos').html('Contenido permitido para <b><i>'+nivel_nombre+'</i></b>');

      let templete = ``;
      datos['contenido'].forEach(element => { 
        console.log(element['nivel_1']['estatus']);

        let estatus     = element['nivel_1']['estatus'];
        let idNivel     = element['nivel_1']['id'];
        let nameNivel   = element['nivel_1']['nombre'];

        let found = datos['contenido_allow'].includes(idNivel);
        let seleccionado = '';
        if(found == true){
          seleccionado = 'checked';
        }

        if(estatus == 1){
          templete += `
            <div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6">
              <div class="form-check">
                <input class="form-check-input" type="checkbox" name="arrayNivelesAllow[]" value="${idNivel}" id="idNivelUno_${idNivel}" ${seleccionado}>
                <label class="form-check-label" for="idNivelUno_${idNivel}">
                  ${nameNivel}
                </label>
              </div>
            </div>
          `;
        }
        
      });

      $('#idDivNivelesList').html(templete);

    },
    error : function(error){
      console.log(error);
    }
  });
}
function contenido_allow_add(id_nivel, arraySeleccionados){
  $.ajax({
    url : 'BackEnd/Nivel_1/contenido_permitido_add.php',
    data : {
      'id_nivel'            : id_nivel,
      'arraySeleccionados'  : arraySeleccionados,
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      $('#idModalNivelesPermisos').modal('hide');

      Swal.fire(
        'Listo',
        'Contenido actualizado correctamente',
        'success'
      )
    },
    error : function(error){
      console.log(error);
    }
  });
}


function nivel_categoria_modal(idNivel, nameNivel){
  $('#idModalUN_Categorias').modal('show');
  $('#idModalUN_Categorias_titulo').html(nameNivel);
  $('#idInputUN_id_nivel_usuario').val(idNivel);
  nivel_categoria_list(idNivel);
}
function nivel_categoria_add(id_nivel_usuario, categoria){
  $.ajax({
    url : 'BackEnd/Usuarios/categoria_add.php',
    data : {
      'id_nivel_usuario' : id_nivel_usuario,
      'categoria' : categoria,
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      Swal.fire(
        'Listo',
        'Guardado correctamente',
        'success'
      )
      $('#idFormUN').trigger('reset');

      nivelesUsuariosList();
      nivel_categoria_list(id_nivel_usuario);
    },
    error : function(error){
      console.log(error);
    }
  });
}
function nivel_categoria_list(idNivelUsr){
  $.ajax({
    url : 'BackEnd/Usuarios/categoria_list.php',
    data : {
      'idNivelUsr' : idNivelUsr,
    },
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);


      // lista en los niveles para la gestion de categorias
      let templete = ``;
      let contador = 1;
      datos.forEach(element => {
        //console.log(element);
        templete += `
        <tr>
          <td>${contador}</td>
          <td>${element['categoria']['categoria']}</td>
          <td style="width:5%">
            <button 
              type="button" 
              class="btn btn-warning btn-sm"
              onclick="nivel_categoria_edit_modal(${idNivelUsr}, ${element['categoria']['id']}, '${element['categoria']['categoria']}')">
              <i class="far fa-edit"></i>
            </button>
          </td>
        </tr>`;
        contador++;
      });
      $('#idTableBodyUN').html(templete);


    },
    error : function(error){
      console.log(error);
    }
  });
}
function nivel_categoria_edit_modal(idNivel, idCat, nameCat){
  $('#idModalUNCatEdit').modal('show');
  $('#idInputUNCatEdit_id_nivel_usr').val(idNivel);
  $('#idInputUNCatEdit_id').val(idCat);
  $('#idInputUNCatEdit_categoria').val(nameCat);
}
function nivel_categoria_edit(id_nivel_usuario, id, categoria){
  $.ajax({
    url : 'BackEnd/Usuarios/categoria_edit.php',
    data : {
      'id_nivel_usuario' : id_nivel_usuario,
      'id' : id,
      'categoria' : categoria,
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      Swal.fire(
        'Listo',
        'Editado correctamente',
        'success'
      )
      $('#idFormUNCatEdit').trigger('reset');
      $('#idModalUNCatEdit').modal('hide');
      

      nivelesUsuariosList();
      nivel_categoria_list(id_nivel_usuario);
    },
    error : function(error){
      console.log(error);
    }
  });
  
}
function mis_categorias(id_usr){
  $.ajax({
    url : 'BackEnd/Usuarios/list.php',
    data : {
      'id' : id_usr,
    },
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      
      /*
      console.log('categorias_nivel');
      console.log(datos[0]['categorias_nivel']);
      console.log('categorias_seleccionadas');
      console.log(datos[0]['categorias_seleccionadas']);
      */

      $('#id_usuario').val(id_usr);


      let templeteMisCategorias = ``;
      if(datos[0]['categorias_nivel'].length == 0){
        templeteMisCategorias = `
        <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4">
          Sin categorías
        </div>`;
      }
      else{
        datos[0]['categorias_nivel'].forEach(element => {
          //console.log(element['categoria']['categoria']);
          let idCategoria = element['categoria']['id'];
          let categoria = element['categoria']['categoria'];
          let found = datos[0]['categorias_seleccionadas'].includes(idCategoria);
          let seleccionado = '';
          if(found == true){
            seleccionado = 'checked';
          }

          templeteMisCategorias += `
          <div class="col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" name="arrayNivelCategorias[]" value="${idCategoria}" id="idNivelCat_${idCategoria}" ${seleccionado}>
              <label class="form-check-label" for="idNivelCat_${idCategoria}">
                ${categoria}
              </label>
            </div>
          </div>
          `;
        });
      }
      $('#idRowMisCategorias').html(templeteMisCategorias);
      
    },
    error : function(error){
      console.log(error);
    }
  });
}
function categorias_nivel_add(id_usuario, arrayMisEtiquetas){
  $.ajax({
    url : 'BackEnd/Usuarios/mis_categorias_add.php',
    data : {
      'id_usuario' : id_usuario,
      'arrayMisEtiquetas' : arrayMisEtiquetas,
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);


      Swal.fire(
        'Listo',
        'Categorias guardadas correctamente',
        'success'
      )
      $('#idModalMisCategorias').modal('hide');
      $('#idFormMisCategorias').trigger('reset');
    },
    error : function(error){
      console.log(error);
    }
  });
}




function nivelesUsuariosAdd(nombre, descripcion){
  $.ajax({
    url : 'BackEnd/Usuarios/nivelesAdd.php',
    data : {'nombre' : nombre, 'descripcion' : descripcion},
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos[0]['id']);

      Swal.fire(
        'Nivel de usuario',
        'Agregado correctamente',
        'success'
      )

      $('#idFormUsuariosNivelNuevo').trigger('reset');
      $('#idModalUsuariosNuevoNivel').modal('hide');
      nivelesUsuariosList()
    },
    error : function(error){
      console.log(error);
    }
  });
}
function nivelesUsuariosModalEdit(id){
  console.log(id);
  console.log('corregir');
  
  $.ajax({
    url : 'BackEnd/Usuarios/niveleSingle.php',
    data : {'id' : id},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos[0]['nivel']);

      $('#idInputUsuarioNivelEdita_id').val(datos[0]['nivel']['id']);
      $('#idInputUsuarioNivelEdita_nombre').val(datos[0]['nivel']['nombre']);
      $('#idInputUsuarioNivelEdita_descripcion').val(datos[0]['nivel']['descripcion']);
    },
    error : function(error){
      console.log(error);
    }
  });
  
}
function nivelesUsuariosEdit(id, nombre, descripcion){
  $.ajax({
    url : 'BackEnd/Usuarios/nivelesEdit.php',
    data : {'id' : id, 'nombre' : nombre, 'descripcion' : descripcion},
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos[0]['id']);

      Swal.fire(
        'Nivel de usuario',
        'Editado correctamente',
        'success'
      )

      $('#idFormUsuariosNivelEdita').trigger('reset');
      $('#idModalUsuarioseEditaNivel').modal('hide');
      nivelesUsuariosList()
    },
    error : function(error){
      console.log(error);
    }
  });
}
function usuariosAdd(idNivel, img, usr, psw, nombre, apepat, apemat, calle, colonia, cp, id_pais, id_estado, mpio, fecha_nacimiento, dato_1, dato_2, cv, estatus){
  $.ajax({
    url : 'BackEnd/Usuarios/add.php',
    data : {
      'idNivel' : idNivel,
      'img'     : img,
      'usr'     : usr,
      'psw'     : psw,
      'nombre'  : nombre,
      'apepat'  : apepat,
      'apemat'  : apemat,
      'calle'     : calle,
      'colonia'   : colonia,
      'cp'        : cp,
      'id_pais'   : id_pais,
      'id_estado' : id_estado,
      'mpio'      : mpio,
      'fecha_nacimiento'  : fecha_nacimiento,
      'dato_1'            : dato_1,
      'dato_2'            : dato_2,
      'cv'                : cv,
      'estatus'           : estatus
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      console.log(datos[0]);

      if(datos[0]['id'] == 1){
        Swal.fire(
          'Listo',
          'Usuario agregado correctamente',
          'success'
        )
        $('#idFormtUsrAdd').trigger('reset');
        $('#idModalUsuarioNuevo').modal('hide');
        usuariosList();
      } else {
        Swal.fire(
          'Error',
          'El usuario ya existe',
          'error'
        )
      }
      
    },
    error : function(error){
      console.log(error);
    } 
  });
}
function usuariosList(){
  $.ajax({
    url : 'BackEnd/Usuarios/list_mi_panel.php',
    success : function(response){
      let datos = JSON.parse(response);

      let templete = ``;
      let cont=1;
      datos.forEach(elemento => {

        /*
        let allow_edit = elemento['crud'][0]['crud_pagina']['modificaciones'];
        let allow_delete = elemento['crud'][0]['crud_pagina']['bajas'];
        */
        let allow_edit = 1;
        let allow_delete = 1;
    
        let img = (elemento['usuario']['img'] != null) ?  '<img class="img-profile rounded-circle" src="img/usuarios/'+elemento['usuario']['img']+'" style="width: 100%;">' : '<i class="far fa-user-circle fa-2x"></i>';



        templete += `
        <tr id="id_tr_${elemento['usuario']['id']}">
          <th scope="row">${cont}</th>
          <td 
            style="cursor:pointer" 
            data-toggle="modal" 
            data-target="#idModalUsuarioEditaFoto" 
            data-toggle="tooltip" 
            data-placement="top" 
            title="Cambiar Foto"
            onclick="cambiarImgUsr(${elemento['usuario']['id']})"
            id="id_td_img_${elemento['usuario']['id']}">
            ${img}
          </td>
          <td id="id_td_nombre_${elemento['usuario']['id']}">
            ${elemento['usuario']['nombre']+' '+elemento['usuario']['apepat']+' '+elemento['usuario']['apemat']} 
            <small>(Id.${elemento['usuario']['id']})</small> <br>
            <a href="../${elemento['usuario']['dato_2']}" target="_blank">
              <small class="font-weight-bold">${elemento['usuario']['dato_1']}</small>
            </a>
          </td>
          <td id="id_td_nivel_${elemento['usuario']['id']}">${elemento['usuario']['nivel_nombre']}</td>
          <td>${elemento['usuario']['usr']}</td>`;
        /*
        templete += `
          <td>
            <input 
              type="password" 
              class="form-control" 
              id="idInputUsrView_psw_${elemento['usuario']['id']}" 
              value="${elemento['usuario']['psw']}"
              readonly>
          </td>`;
          */
        
          /*
        templete += `  
          <td>
            <button 
              type="button" 
              class="btn btn-link btn-sm"
              id="idBtntUsrShow_psw_${elemento['usuario']['id']}"
              onclick="showPsw(${elemento['usuario']['id']})"
              style="display: block;">
              <i class="far fa-eye"></i>
            </button>
            <button 
              type="button" 
              class="btn btn-link btn-sm"
              id="idBtntUsrHide_psw_${elemento['usuario']['id']}"
              onclick="hidePsw(${elemento['usuario']['id']})"
              style="display: none;">
              <i class="far fa-eye-slash"></i>
            </button>
          </td>`;
          */

          templete += `  
          <td>
            <button 
              type="button"
               class="btn btn-outline-primary btn-sm"
               data-toggle="tooltip" data-placement="top" title="Cambiar Contraseña"
               onclick="modalDatosEditPsw(${elemento['usuario']['id']})";>
              <i class="fas fa-key"></i>
            </button>
          </td>`;

        templete += `
          <td>
            <button 
              type="button" 
              class="btn btn-outline-primary btn-sm"
              data-toggle="modal" 
              data-target="#idModalUsrFormasContacto"
              data-toggle="tooltip" data-placement="top" title="Formas de Contacto"
              onclick="formasContactoList(${elemento['usuario']['id']}, '${elemento['usuario']['dato_2']}')">
              <i class="far fa-address-book"></i>
            </button>
          </td>`;

          //Edita usuario
        if(allow_edit == 1) {
          templete += `
          <td>
            <button 
              type="button" 
              class="btn btn-outline-primary btn-sm"
              data-toggle="modal" 
              data-target="#idModalUsuarioEdita"
              data-toggle="tooltip" data-placement="top" title="Editar Usuario"
              onclick="modalEditaUsuario(${elemento['usuario']['id']})">
              <i class="far fa-edit"></i>
            </button>
          </td>`;
        } else {
          templete += `
          <td></td>`;
        }



        if(elemento['usuario']['estatus'] == 1){
          templete += `
          <td>
            <button 
              type="button" 
              class="btn btn-outline-success btn-sm"
              onclick="usrApagar(${elemento['usuario']['id']})"
              id="id_td_btnSwitch_${elemento['usuario']['id']}">
              <i class="fas fa-toggle-on"></i> 
            </button>
          </td>
          `;
        }
        else {
          templete += `
          <td>
            <button 
              type="button" 
              class="btn btn-outline-danger btn-sm"
              onclick="usrPrender(${elemento['usuario']['id']})"
              id="id_td_btnSwitch_${elemento['usuario']['id']}">
              <i class="fas fa-toggle-off"></i>
            </button>
          </td>
          `;
        }


        if(allow_delete == 1) {
          templete += `
          <td>
            <button 
              type="button" 
              class="btn btn-outline-danger btn-sm"
              data-toggle="tooltip" data-placement="top" title="Eliminar Usuario"
              onclick="deleteUser(${elemento['usuario']['id']})">
              <i class="far fa-trash-alt"></i>
            </button>
          </td>`;
        } else {
          templete += `
          <td></td>`;
        }
        

          templete += `
        </tr>
        `;
        cont++;
      });
      $('#idTableBodyUsrList').html(templete);

      $('#idTableUsrList').DataTable();

    },
    error : function(error){
      console.log(error);
    }
  });
}
function ir_contenido(id_usuario, dato_1){
  //console.log(id_usuario);
  console.log(dato_1);
  localStorage.setItem('dato1Usr_adminContenido', dato_1);
  localStorage.setItem('idUsr_adminContenido', id_usuario);
  window.location.href = 'administrador_contenido.html';
}
function usrApagar(id){
  //console.log('apagar id usuario: '+id);
  Swal.fire({
    title: '¿Deseas apagar el usuario?',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Si',
    cancelButtonText: 'No'
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url : 'BackEnd/Usuarios/switch.php',
        data : { 'id' : id , 'estatus' : 0 },
        type : 'POST',
        success : function(response){
          //console.log(response);

          Swal.fire(
            'Listo',
            'Apagado correctamente',
            'success' 
          );

          /*
          let templeteUsrLoading = `
          <tr>
            <th colspan="9">
              <div class="spinner-border" role="status">
                <span class="visually-hidden"></span> 
              </div>
              Cargando...
            </th>
          </tr>
          `;
          $('#idTableBodyUsrList').html(templeteUsrLoading);

          usuariosList();
          */

          $('#id_td_btnSwitch_'+id).html('<i class="fas fa-toggle-off"></i>');
          $('#id_td_btnSwitch_'+id).attr('class', 'btn btn-outline-danger btn-sm');

        },
        error : function(error){
          console.log(error);
        }
      });
    }
  })
}
function usrPrender(id){
  //console.log('prender id usuario: '+id);
  Swal.fire({
    title: '¿Deseas prender el usuario?',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Si',
    cancelButtonText: 'No'
  }).then((result) => {
    if (result.isConfirmed) {
      $.ajax({
        url : 'BackEnd/Usuarios/switch.php', 
        data : { 'id' : id , 'estatus' : 1 },
        type : 'POST',
        success : function(response){
          //console.log(response);

          Swal.fire(
            'Listo',
            'Prendido correctamente',
            'success'
          );

          /*
          let templeteUsrLoading = `
          <tr>
            <th colspan="9">
              <div class="spinner-border" role="status">
                <span class="visually-hidden"></span> 
              </div>
              Cargando...
            </th>
          </tr>
          `;
          $('#idTableBodyUsrList').html(templeteUsrLoading);

          usuariosList();
          */

          $('#id_td_btnSwitch_'+id).html('<i class="fas fa-toggle-on"></i>');
          $('#id_td_btnSwitch_'+id).attr('class', 'btn btn-outline-success btn-sm');

        },
        error : function(error){
          console.log(error);
        }
      });
    }
  })
}
function modalDatosEditPsw(idUsr){
  $('#idModalEditPsw').modal('show');
  $('#idInputEditPsw_id').val(idUsr);
}
function changePassword(newPsw, idUsr){
  $.ajax({
    url : 'BackEnd/Usuarios/edit-psw.php',
    data :  {
      'newPsw' : newPsw,
      'idUsr'  : idUsr,
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      $('#idModalEditPsw').modal('hide');
      $('#idFormEditPsw').trigger('reset');

      Swal.fire(
        'Listo',
        'Editado correctamente',
        'success'
      )
    },
    error : function(error){
      console.log();
    }
  });
}
function cambiarImgUsr(id){
  //console.log(id);
  $('#idInputUsrIdPerfil').val(id);
}
function changePictureProfile(id, formData){
  $.ajax({
    url : 'BackEnd/Usuarios/edita-foto-perfil.php',
    data : formData,
    type : 'POST',
    contentType : false,
    processData : false,
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos['query']);

      $('#idModalUsuarioEditaFoto').modal('hide');
      $('#idFormUsrImgPerfil').trigger('reset');
      Swal.fire(
        '¡Listo!',
        '¡Insertado correctamente!',
        'success'
      )

      //actualiza imagen
      let newImg = `<img class="img-profile rounded-circle" src="img/usuarios/${datos['img']}" style="width: 100%;">`;
      $('#id_td_img_'+id).html(newImg);

    },
    error : function(error){
      console.log(error);
    }
  });
}
function modalEditaUsuario(id){
  //console.log(id);
  $.ajax({
    url : 'BackEnd/Usuarios/list.php',
    data : {'id' : id},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos[0]['categorias']);

      let nivelId   = datos[0]['usuario']['id_nivel'];
      let gerente   = datos[0]['usuario']['gerente'];
      let nivelNombre = datos[0]['usuario']['nivel_nombre'];
      let usr       = datos[0]['usuario']['usr'];
      let psw       = datos[0]['usuario']['psw'];
      let nombre    = datos[0]['usuario']['nombre'];
      let apepat    = datos[0]['usuario']['apepat'];
      let apemat    = datos[0]['usuario']['apemat'];
      let calle     = datos[0]['usuario']['calle'];
      let colonia   = datos[0]['usuario']['colonia'];
      let cp        = datos[0]['usuario']['cp'];
      let id_pais   = datos[0]['usuario']['id_pais'];
      let id_estado = datos[0]['usuario']['id_estado'];
      let mpio      = datos[0]['usuario']['mpio'];
      let f_nac      = datos[0]['usuario']['fecha_nacimiento'];
      let dato_1      = datos[0]['usuario']['dato_1'];
      let dato_2      = datos[0]['usuario']['dato_2'];
      let cv          = datos[0]['usuario']['cv'];


      let templete = `
        <option value="0">No</option>
        <option value="1">Si</option>
      `;
      if(gerente == 1){
        templete = `
          <option value="1">Si</option>
          <option value="0">No</option>
        `;
      }
      $('#idInputUsrEdit_gerente').html(templete);

      if(nivelId == 22){
        $('#idDivColNivelEdit').removeClass("col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 mt-2").addClass("col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 mt-2");
  
        var divStyle = $("#idDivColGerenteEdit").prop("style");
        divStyle.removeProperty("display");
      }
      else {
        $('#idDivColNivelEdit').removeClass("col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 mt-2").addClass("col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 mt-2");
        $('#idDivColGerenteEdit').attr('style', 'display: none;');
        $('#idInputUsrEdit_gerente').val(0);
      }


      
      if(cv != null) {
        ckeUsuarioCVEdit.setData(cv);
      } else {
        ckeUsuarioCVEdit.setData('');
      }
      

      if(id_pais == 0){
        nombre_pais = '---';
      } else{
        nombre_pais = datos[0]['pais']['nombre'];
      }
      //console.log('id_pais: '+id_pais+' nombre_pais: '+nombre_pais);

      if(id_estado == 0){
        nombre_estado = '---';
      } else{
        nombre_estado = datos[0]['estado']['nombre'];
      }
      //console.log('id_estado: '+id_estado+' nombre_estado: '+nombre_estado);


      $('#idInputUsrEdit_id').val(id);
      $('#idInputUsrEdit_nivel').val(nivelId);
      $('#idInputUsrEdit_usr').val(usr);
      $('#idInputUsrEdit_psw').val(psw);
      $('#idInputUsrEdit_nombre').val(nombre);
      $('#idInputUsrEdit_apepat').val(apepat);
      $('#idInputUsrEdit_apemat').val(apemat);
      $('#idInputUsrEdit_calle').val(calle);
      $('#idInputUsrEdit_colonia').val(colonia);
      $('#idInputUsrEdit_cp').val(cp);
      $('#idInputUsrEdit_mpio').val(mpio);
      $('#idInputUsrEdit_fecha_nacimiento').val(f_nac);
      $('#idInputUsrEdit_dato_1').val(dato_1);
      $('#idInputUsrEdit_dato_2').val(dato_2);

      localStorage.setItem('id_nivel', nivelId);
      localStorage.setItem('usrEdit_nivelNombre', nivelNombre);

      localStorage.setItem('usrEdit_paisId', id_pais);
      localStorage.setItem('usrEdit_paisNombre', nombre_pais);
      localStorage.setItem('usrEdit_estadoId', id_estado);
      localStorage.setItem('usrEdit_estadoNombre', nombre_estado);

      nivelesUsuariosList();
      catalogo_paises(); 
      catalogo_estados(id_pais);



    },
    error : function(error){
      console.log(error);
    }
  });
}
function editUser(id, idNivel, gerente, nameNivel, usr, nombre, apepat, apemat, calle, colonia, cp, id_pais, id_estado, mpio, fecha_nacimiento, dato_1, dato_2, cv){

  $.ajax({
    url : 'BackEnd/Usuarios/edit.php',
    data : {
      'id'      : id,
      'idNivel' : idNivel,
      'gerente' : gerente,
      'usr'     : usr,
      'nombre'  : nombre,
      'apepat'  : apepat,
      'apemat'  : apemat,
      'calle'     : calle,
      'colonia'   : colonia,
      'cp'        : cp,
      'id_pais'   : id_pais,
      'id_estado' : id_estado,
      'mpio'      : mpio,
      'fecha_nacimiento'  : fecha_nacimiento,
      'dato_1'            : dato_1,
      'dato_2'            : dato_2,
      'cv'                : cv,
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos['query']);

      /*
      let templeteUsrLoading = `
        <tr>
          <th colspan="9">
            <div class="spinner-border" role="status">
              <span class="visually-hidden"></span> 
            </div>
            Cargando...
          </th>
        </tr>
        `;
        $('#idTableBodyUsrList').html(templeteUsrLoading);  
      */
      $('#idModalUsuarioEdita').modal('hide');

      //usuariosList();
      //actualiza datos de la tabla
      let td_nombre = `
        ${nombre+' '+apepat+' '+apemat} <small>(Id.${id})</small> <br>
            <small class="font-weight-bold">${dato_1}</small>
      `;
      $('#id_td_nombre_'+id).html(td_nombre);
      $('#id_td_nivel_'+id).html(nameNivel);

      

      Swal.fire(
        'Listo',
        'Usuario editado correctamente',
        'success'
      )
    },
    error : function(error) {
      console.log(error);
    }
  });
}
function deleteUser(id){
  Swal.fire({
    title: '¿Estas seguro?',
    text: "¡No podrás revertir esto!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: '¡Si, borrarlo!'
  }).then((result) => {
    if (result.isConfirmed) {

      $.ajax({
        url : 'BackEnd/Usuarios/delete.php',
        data : {'id' : id},
        type : 'POST',
        success : function(response){
          console.log(response);
          usuariosList();

          Swal.fire(
            '¡Listo!',
            'Usuario eliminado correctamente.',
            'success'
          )
        },
        error : function(error){
          console.log(error);
        }
      });
    }
  })

}
function showPsw(id){
  //console.log(id);
  $('#idInputUsrView_psw_'+id).attr('type', 'text');
  $('#idBtntUsrShow_psw_'+id).attr('style', 'display: none');
  $('#idBtntUsrHide_psw_'+id).attr('style', 'display: block');
}
function hidePsw(id){
  //console.log(id);
  $('#idInputUsrView_psw_'+id).attr('type', 'password');
  $('#idBtntUsrShow_psw_'+id).attr('style', 'display: block');
  $('#idBtntUsrHide_psw_'+id).attr('style', 'display: none');
}
function catalogo_paises(){
  $.ajax({
    url : 'BackEnd/Catalogo_2/list.php',
    data : {'idCatalogo1' : 1},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      // ====================== DIRECCCION 1 ======================
      //MUESTRA LISTA DE PAISES
      let templete = `<option value="0">---</option>`;
      datos.forEach(elemento => {
        //console.log(elemento);
        templete += `
        <option value="${elemento['elemento']['id']}">${elemento['elemento']['nombre']}</option>
        `;
      });
      $('#idInputUsrAdd_pais').html(templete);
      $('#idInputUsrAdd_estado').html('<option value="0">---</option>');
      
      //SELECCIONA PAIS Y MUESTRA LISTA ESTADOS
      $('#idInputUsrAdd_pais').change(function(){
        $('#idInputUsrAdd_estado').html('<option value="0">---</option>');
        let idPais = $('#idInputUsrAdd_pais').val();
        if(idPais != null && idPais != ''){
          catalogo_estados(idPais);
        }
      });


      // ====================== DIRECCCION EDITA USUARIO ======================
      //MUESTRA LISTA DE PAISES
      let ue_paisId   = localStorage.getItem('usrEdit_paisId');
      let ue_paisName = localStorage.getItem('usrEdit_paisNombre');

      let templete2 = `<option value="${ue_paisId}">${ue_paisName}</option>`;
      datos.forEach(elemento => {
        //console.log(elemento);
        templete2 += `
        <option value="${elemento['elemento']['id']}">${elemento['elemento']['nombre']}</option>
        `;
      });
      $('#idInputUsrEdit_pais').html(templete2);

      $('#idInputUsrEdit_pais').change(function(){
        let idPaisSelect = $('#idInputUsrEdit_pais').val();
        localStorage.setItem('usrEdit_estadoId', 0);
        localStorage.setItem('usrEdit_estadoNombre', '---');
        catalogo_estados(idPaisSelect);
      });

    },
    error : function(error){
      console.log(error);
    }
  });
}
function catalogo_estados(idPais) {
  $.ajax({
    url : 'BackEnd/Catalogo_3/list.php',
    data : {'idCatalogo2' : idPais},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      //mmmmmmmmmmmmmmmmmmmmmmm DIRECCION 2 ADD
      let templete = `<option value="0">---</option>`;
      datos.forEach(elemento => {
        templete += `
        <option value="${elemento['elemento']['id']}">${elemento['elemento']['nombre']}</option>
        `;
      });
      $('#idInputUsrAdd_estado').html(templete);


      //mmmmmmmmmmmmmmmmmmmmmmm DIRECCION EDITA USUARIO
      let ue_estadoId   = localStorage.getItem('usrEdit_estadoId');
      let ue_estadoName = localStorage.getItem('usrEdit_estadoNombre');

      let templete2 = `<option value="${ue_estadoId}">${ue_estadoName}</option>`;
      datos.forEach(elemento => {
        templete2 += `
        <option value="${elemento['elemento']['id']}">${elemento['elemento']['nombre']}</option>
        `;
      });
      $('#idInputUsrEdit_estado').html(templete2);
    },
    error : function(error){
      console.log(error);
    }
  });
}

