$(function(){
  console.log('usuarios-relacionados is running...');

  allowCrud(27);

  $('#idFormUsrAdicional_add').submit(function(e){
    e.preventDefault();
    let idNivel = $('#idInputUsrAdicional_nivel').val();
    let usr     = $('#idInputUsrAdicional_usr').val();
    let psw     = $('#idInputUsrAdicional_psw').val();

    add_usr_adicional(idNivel, usr, psw);
  });

  list_usr_adicional();
});


function allowCrud(idPagina) {
  //console.log(idPagina);
  $.ajax({
    url : 'BackEnd/Permisos/crud-allow.php',
    data : {'idPagina' : idPagina},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos[0]['crud_pagina']);

      // BOTON ADD - USUARIO
      let templete= ``;
      if(datos[0]['crud_pagina']['altas'] == 1) {
        templete = `
          <button 
            type="button" 
            class="btn btn-primary btn-sm" 
            onclick="modal_usr_adicional()">
            <i class="fas fa-plus"></i> Nuevo usuario
          </button>`;
      } 
      $('#idDivUsrAdicional_add').html(templete);


    },
    error : function(error){
      console.log(error);
    }
  });
}

function modal_usr_adicional(){
  nivelesUsuariosList();

  $('#idModalUsrAdicional_add').modal('show');
  let fecha = new Date();
  let anio = fecha.getFullYear();
  let mes = fecha.getMonth() + 1;
  let dia = fecha.getDate();
  let hora = fecha.getHours();
  let min = fecha.getMinutes();
  let sec = fecha.getSeconds();

  nameAd = anio+''+mes+''+dia+'_'+hora+''+min+''+sec;
  let emailAd = nameAd+'@temporal.com';
  $('#idInputUsrAdicional_usr').val(emailAd);
}

function nivelesUsuariosList(){
  $.ajax({
    url : 'BackEnd/Usuarios/nivelesList.php',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      //Inicio - Muestra en lista para agregar un nuevo usuario
      let templeteList ;
      datos.forEach(nivelList => {
        if(nivelList['nivel']['id'] == 4 || nivelList['nivel']['id'] == 5 || nivelList['nivel']['id'] == 6) {
          //console.log(nivelList['nivel']['nombre']);
          templeteList += `
          <option value="${nivelList['nivel']['id']}">${nivelList['nivel']['nombre']}</option>
          `;
        }
      });
      $('#idInputUsrAdicional_nivel').html(templeteList);
      //Inicio - Muestra en lista para agregar un nuevo usuario
    },
    error : function(error){
      console.log(error);
    }
  });
}

function add_usr_adicional(idNivel, usr, psw) {
  //console.log(idNivel, usr, psw);
  $.ajax({
    url : 'BackEnd/Usuarios/adicional_add.php',
    data : {'idNivel' : idNivel, 'usr' : usr, 'psw' : psw},
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      $('#idModalUsrAdicional_add').modal('hide');
      $('#idFormUsrAdicional_add').trigger('reset');

      Swal.fire(
        'Listo',
        'Usuario creado correctamente',
        'success'
      )

      list_usr_adicional();
    },
    error : function(error){
      console.log(error);
    }
  });
}

function list_usr_adicional(){
  $.ajax({
    url : 'BackEnd/Usuarios/adicional_list.php',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      let templete = ``;
      let cont = 1;

      datos.forEach(usr => {
        //console.log(usr['usuario']);
        templete += `
        <tr>
          <th>${cont}</th>
          <td>${usr['usuario']['usr']}</td>
          <td>${usr['usuario']['psw']}</td>
          <td>${usr['usuario']['nivel_nomnre']}</td>
          <td>
            <button 
              type="button" 
              class="btn btn-outline-danger btn-sm"
              onclick="delete_usr_adicional(${usr['usuario']['id']}, ${usr['usuario']['id_usr_propietario']}, ${usr['usuario']['id_usr_relacionado']});">
              <i class="far fa-trash-alt"></i>
            </button>
          </td>
        </tr>
        `;
        cont++;
      });
      $('#idTableBodyUsrAdiList').html(templete);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function delete_usr_adicional(id, idUsrPropietario, idUsrRelacionado){
  
  Swal.fire({
    title: '¿Estas seguro?',
    text: "¡No podrás revertir esto!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: '¡Si, borrarlo!'
  }).then((result) => {
    if (result.isConfirmed) {

      $.ajax({
        url : 'BackEnd/Usuarios/adicional_delete.php',
        data : {
          'id'                : id,
          'idUsrPropietario'  : idUsrPropietario,
          'idUsrRelacionado'  : idUsrRelacionado,
        },
        type : 'GET',
        success : function(response){
          console.log(response);
    
          list_usr_adicional();

          Swal.fire(
            'Listo!',
            'Usuario eliminado correctamente.',
            'success'
          )
        },
        error : function(error){
          console.log(error);
        }
      });

      
    }
  })

  
}