
//LocalStore Pais
let idPaisPerfil = localStorage.getItem('idPaisPerfil');
let paisPerfil = localStorage.getItem('paisPerfil');
//LocalStore Estado
let idEstadoPerfil = localStorage.getItem('idEstadoPerfil');
let estadoPerfil = localStorage.getItem('estadoPerfil');

$(function(){
  console.log('sesionPerfil is running...');

  perfilSingle();
  catalogoPaises();
  catalogoEstados(idPaisPerfil);

  $('#idPerfilPais').change(function(){
    let idPais = $('#idPerfilPais').val();
    catalogoEstados(idPais);
  });

  //Edita datos personales
  $('#idFormPerfilDatos').submit(function(e){
    e.preventDefault();
    let usuario         = $('#idPerfilUsuario').val();
    let nombre          = $('#idPerfilNombre').val();
    let paterno         = $('#idPerfilPaterno').val();
    let materno         = $('#idPerfilMaterno').val();
    let fechaNacimiento = $('#idPerfilFechaNacimiento').val();
    let idPais          = $('#idPerfilPais').val();
    let idEstado        = $('#idPerfilEstado').val();
    let municipio       = $('#idPerfilMunicipio').val();

    //console.log(usuario, nombre, paterno, materno, fechaNacimiento, idPais, idEstado, municipio);
    perfilEditDatos(usuario, nombre, paterno, materno, fechaNacimiento, idPais, idEstado, municipio);
  });

  //Edita foto
  $('#idFormPerfilFoto').submit(function(e){
    e.preventDefault();

    let foto_archivo  = $('#idPerfilFotoEdita')[0].files[0];

    var formData = new FormData();
    formData.append('foto_archivo', foto_archivo);

    perfilEditFoto(formData);
  });

  //Edita contrasena
  $('#idFormPerfilContrasena').submit(function(e){
    e.preventDefault();

    let pswActual  = $('#idCambiarPswActual').val();
    let pswNueva  = $('#idCambiarPswNueva').val();
    //console.log('pswActual: '+pswActual+' pswNueva: '+pswNueva+' pswNueva2: '+pswNueva2);
    perfilEditContrasena(pswActual, pswNueva);
  });
  

});

function perfilSingle(){
  $.ajax({
    url : 'BackEnd/Sesion/perfilSingle.php',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos[0]);

      let foto = datos[0]['item']['portada'];

      let usr = datos[0]['item']['titulo'];
      let psw = datos[0]['item']['campo_4'];

      let nombre = datos[0]['item']['campo_1'];
      let paterno = datos[0]['item']['campo_2'];
      let materno = datos[0]['item']['campo_3'];

      let fechaNacimiento = datos[0]['item']['dia_publicacion'];

      let idPais = datos[0]['item']['id_pais'];
      let pais = (idPais == 0) ? 'Selecciona Pais' : datos[0]['pais']['nombre'];
      localStorage.setItem('idPaisPerfil', idPais);
      localStorage.setItem('paisPerfil', pais);

      let idEstado = datos[0]['item']['id_estado'];
      let estado = (idEstado == 0) ? 'Selecciona Estado' : datos[0]['estado']['nombre'];
      localStorage.setItem('idEstadoPerfil', idEstado);
      localStorage.setItem('estadoPerfil', estado);

      let municipio = datos[0]['item']['municipio'];

      $('#idPerfilFoto').attr('src', 'img/items/'+foto);
      $('#idPerfilUsuario').val(usr);
      $('#idPerfilNombre').val(nombre);
      $('#idPerfilPaterno').val(paterno);
      $('#idPerfilMaterno').val(materno);
      $('#idPerfilFechaNacimiento').val(fechaNacimiento);
      $('#idPerfilMunicipio').val(municipio);

    },
    error : function(error){
      console.log(error);
    }
  });
}

function perfilEditDatos(usuario, nombre, paterno, materno, fechaNacimiento, idPais, idEstado, municipio){
  $.ajax({
    url : 'BackEnd/Sesion/perfilEditaDatos.php',
    data : {
      'usuario'         : usuario,
      'nombre'          : nombre,
      'paterno'         : paterno,
      'materno'         : materno,
      'fechaNacimiento' : fechaNacimiento,
      'idPais'          : idPais,
      'idEstado'        : idEstado,
      'municipio'       : municipio,
    },
    type : 'POST',
    success : function(response){
      //console.log(response);

      Swal.fire(
        'Perfil editado correctamente',
        '',
        'success'
      )

      perfilSingle();
    },
    error : function(error){
      console.log(error);
    }
  });
}

function perfilEditFoto(formData){
  $.ajax({
    url : 'BackEnd/Sesion/perfilEditaFoto.php',
    data : formData,
    type : 'POST',
    contentType : false,
    processData : false,
    success : function(response){
      //console.log(response);

      perfilSingle();

      $('#idModalPerfilFoto').modal('hide');
      $('#idFormPerfilFoto').trigger('reset');

      Swal.fire(
        'Foto de perfil editada correctamente',
        '',
        'success'
      )
    },
    error : function(error){
      console.log(error);
    }
  });
}

function perfilEditContrasena(pswActual, pswNueva){
  //console.log(pswActual, pswNueva);
  $.ajax({
    url : 'BackEnd/Sesion/perfilEditaContrasena.php',
    data : {
      'pswActual'   : pswActual, 
      'pswNueva'    : pswNueva
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      
      $('#idModalPerfilContrasena').modal('hide');
      $('#idFormPerfilContrasena').trigger('reset');

      if(datos['idPsw'] == 0){
        Swal.fire(
          'La contraseña actual no coincide',
          '',
          'error'
        )
      } else {
        Swal.fire(
          'Contraseña editada correctamente',
          '',
          'success'
        )
      }
      
      
    },
    error : function(error){
      console.log(error);
    }
  });
}

function catalogoPaises(){
  $.ajax({
    url : 'BackEnd/Catalogos/paises.php',
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      
      /* ============== inicio ============== */
      let templetePaisPerfil = `<option value="${idPaisPerfil}">${paisPerfil}</option>`;
      datos.forEach(function(pais, idx) {
        templetePaisPerfil += `
          <option value="${pais['pais']['id']}">${pais['pais']['nombre']}</option>
        `;
      });
      $('#idPerfilPais').html(templetePaisPerfil);
      /* ============== Fin ============== */
    },
    error : function(error){
      console.log(error);
    }
  });
}

function catalogoEstados(idPais){
  $.ajax({
    url : 'BackEnd/Catalogos/estados.php',
    data : {'idPais' : idPais},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);
      /* ============== inicio ============== */
      let templeteEstadoPerfil = `<option value="${idEstadoPerfil}">${estadoPerfil}</option>`;
      datos.forEach(function(estado, idx) {
        templeteEstadoPerfil += `
          <option value="${estado['estado']['id']}">${estado['estado']['nombre']}</option>
        `;
      });
      $('#idPerfilEstado').html(templeteEstadoPerfil);
      /* ============== Fin ============== */
    },
    error : function(error){
      console.log(error);
    }
  });
}