$(function(){
  //console.log('permisos is running...');

  paginaList();
  nivelesList();

  //form PAGINA ADD
  $('#idFormPaginaAdd').submit(function(e){
    e.preventDefault();
    let fontawesome = $('#idInputPaginaAdd_fontawesome').val();
    let nombre      = $('#idInputPaginaAdd_nombre').val();
    let pagina      = $('#idInputPaginaAdd_pagina').val();
    let menu        = $('#idInputPaginaAdd_menu').val();
    
    paginaAdd(fontawesome, nombre, pagina, menu);
  });

  //form PAGINA EDIT
  $('#idFormPaginaEdit').submit(function(e){
    e.preventDefault();
    let id          = $('#idInputPaginaEdit_id').val();
    let fontawesome = $('#idInputPaginaEdit_fontawesome').val();
    let nombre      = $('#idInputPaginaEdit_nombre').val();
    let pagina      = $('#idInputPaginaEdit_pagina').val();
    let menu        = $('#idInputPaginaEdit_menu').val();
    

    paginaEdit(id, fontawesome, nombre, pagina, menu);
  });

  //form PERMISOS
  $('#idFormPermisos').submit(function(e){
    e.preventDefault();

    let nivelUsuario            = $('#idInputPaginaPermitida_nivelUsr').val();
    let allCheckbox             = document.getElementsByName('nameInputPaginaPermitida[]');
    var allCheckboxLength       = allCheckbox.length;  
    let checkboxSeleccionados   = [];

    for(i = 0; i < allCheckboxLength; i++){
      if(allCheckbox[i].checked) {
        //console.log(allCheckbox[i].id);
        checkboxSeleccionados.push($('#'+allCheckbox[i].id).val());
      }
    } 
    //console.log(nivelUsuario, checkboxSeleccionados);
    permisosAdd(nivelUsuario, checkboxSeleccionados);
  });

  
  //form CRUD
  $('#idFormCRUD').submit(function(e){
    e.preventDefault();

    let idNivelUsuario  = $('#idCheckCRUD_idNivelUsr').val();
    let idPagina        = $('#idCheckCRUD_idPagina').val();
    let val_a = 0;
    let val_b = 0;
    let val_m = 0;
    let val_c = 0;

    //altas
    if(document.getElementsByName('nameA')[0].checked == true){
      val_a = 1;
    }
    //bajas
    if(document.getElementsByName('nameB')[0].checked == true){
      val_b = 1;
    }
    //modificaciones
    if(document.getElementsByName('nameM')[0].checked == true){
      val_m = 1;
    }
    //consultas
    if(document.getElementsByName('nameC')[0].checked == true){
      val_c = 1;
    }

    //console.log(idNivelUsuario, idPagina, val_a, val_b, val_m, val_c);
    usuarioPaginaCRUD(idNivelUsuario, idPagina, val_a, val_b, val_m, val_c);
  });

  //22 id pagina permisos.html en la tabla g13_paginas
  allowCrud(22);
  
});

function allowCrud(idPagina) {
  //console.log(idPagina);
  $.ajax({
    url : 'BackEnd/Permisos/crud-allow.php',
    data : {'idPagina' : idPagina},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos[0]['crud_pagina']['altas']);

      // BOTON ADD - NIVEL
      let templete = ``;
      if(datos[0]['crud_pagina']['altas'] == 1) {
        templete = `
        <button 
          type="button" 
          class="btn btn-primary btn-sm" 
          data-toggle="modal" 
          data-target="#idModalPaginaAdd">
          <i class="fas fa-plus"></i> Página nueva
        </button>`;
      } 
      $('#idDivPermiso_add').html(templete);

    },
    error : function(error){
      console.log(error);
    }
  });
}

function permisosAdd(nivelUsuario, checkboxSeleccionados){
  //console.log(nivelUsuario, checkboxSeleccionados);
  $.ajax({
    url : 'BackEnd/Permisos/add.php',
    data : { 
      'nivelUsuario'          : nivelUsuario,
      'idPaginasPermitidas'   : checkboxSeleccionados,
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      Swal.fire(
        'Listo',
        'Permisos asignados',
        'success'
      )

      $('#idModalPermisos').modal('hide');
      nivelesList();

    },
    error : function(error){
      console.log(error);
    }
  });
}

function permisosList(nivelUsuario){
  //console.log(nivelUsuario, checkboxSeleccionados);
  $.ajax({
    url : 'BackEnd/Permisos/list.php',
    data : { 
      'nivelUsuario'          : nivelUsuario
    },
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      let templete = ``;
      datos.forEach(elemento => {
        //console.log(elemento);
        console.log(elemento['crud'][0]['crud_pagina']['altas']);

        if(elemento['crud'][0]['crud_pagina']['altas'] == 1) {
          templete += `
            <span 
              style="cursor: pointer;"
              class="badge badge-secondary"  
              data-toggle="modal" 
              data-target="#idModalCRUD"
              onclick="showUsuarioPaginaCRUD(${nivelUsuario}, ${elemento['pagina']['id_pagina']})">
              ${elemento['pagina']['pagina']}
            </span>
            `;
        } else {
          templete += `
            <span 
              class="badge badge-secondary">
              ${elemento['pagina']['pagina']}
            </span>
            `;
        }
        
      });
      $('#idDivListPaginasPermitidasNivel_'+nivelUsuario).html(templete);

    },
    error : function(error){
      console.log(error);
    }
  });
}

function showUsuarioPaginaCRUD(idNivelUsr, idPagina) {
  //console.log(idNivelUsr, idPagina);
  $.ajax({
    url : 'BackEnd/Permisos/crud-list.php',
    data : {'idNivelUsr' : idNivelUsr, 'idPagina' : idPagina},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      // console.log(datos[0]['pagina']);
      // console.log(datos[0]['pagina']['altas']);
      // console.log(datos[0]['pagina']['bajas']);
      // console.log(datos[0]['pagina']['modificaciones']);
      // console.log(datos[0]['pagina']['consultas']);

      $('#idCheckCRUD_idNivelUsr').val(idNivelUsr);
      $('#idCheckCRUD_idPagina').val(idPagina);

      //TITULO MODAL
      let templeteTitulo = `<b>CRUD</b> <small class="text-primary font-weight-bold"> (${datos[0]['pagina']['nombre_usuario']} - ${datos[0]['pagina']['pagina']})</small>`;
      $('#idModalCRUD_titulo').html(templeteTitulo);

      //ALTAS
      if(datos[0]['pagina']['altas'] == 1){
        document.getElementById("idCheckCRUD_altas").checked = true;
      }
      //BAJAS
      if(datos[0]['pagina']['bajas'] == 1){
        document.getElementById("idCheckCRUD_bajas").checked = true;
      }
      //MODIFICACIONES
      if(datos[0]['pagina']['modificaciones'] == 1){
        document.getElementById("idCheckCRUD_modificaciones").checked = true;
      }

    },
    error : function(error){
      console.log(error);
    }
  });
}

function usuarioPaginaCRUD(idNivelUsuario, idPagina, altas, bajas, modificaciones, consultas){
  $.ajax({
    url : 'BackEnd/Permisos/crud-edit.php',
    data : {
      'idNivelUsuario'  : idNivelUsuario,
      'idPagina'        : idPagina,
      'altas'           : altas,
      'bajas'           : bajas,
      'modificaciones'  : modificaciones,
      'consultas'       : consultas,
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      Swal.fire(
        'Listo',
        'CRUD Actualizado',
        'success'
      )

      $('#idModalCRUD').modal('hide');
      showUsuarioPaginaCRUD(idNivelUsuario, idPagina);

    },
    error : function(error){
      console.log(error);
    }
  });
}

function paginaAdd(fontawesome, nombre, pagina, menu){
  $.ajax({
    url : 'BackEnd/Paginas/add.php',
    data : { 
      'fontawesome' : fontawesome,
      'nombre'      : nombre,
      'pagina'      : pagina,
      'menu'        : menu,
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      Swal.fire(
        'Listo',
        'Agregado correcto',
        'success'
      )
      
      $('#idModalPaginaAdd').modal('hide');
      $('#idFormPaginaAdd').trigger('reset');
      paginaList();
    },
    error : function(error){
      console.log(error);
    }
  });
}

function paginaList() {
  $.ajax({
    url : 'BackEnd/Paginas/list.php',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      let templete = ``;
      let cont = 1;
      datos.forEach(pagina => {
        //console.log(pagina['crud'][0]['crud_pagina']['altas']);
        templete += `
        <tr>
          <th scope="row">${cont}</th>
          <td>${(pagina['pagina']['fontawesome']) ? pagina['pagina']['fontawesome'] : ''} ${pagina['pagina']['nombre']}</td>
          <td>${pagina['pagina']['pagina']} <small>(Id. ${pagina['pagina']['id']})</small></td>
          <td class="text-center">
          ${(pagina['pagina']['menu'] == 1) ? '<i class="fas fa-circle text-success"></i>' : '<i class="fas fa-circle text-danger"></i>'}
          </td>`;

        if(pagina['crud'][0]['crud_pagina']['modificaciones'] == 1) {
          templete += `
            <td>
              <button 
                type="button" 
                class="btn btn-outline-warning btn-sm"
                data-toggle="modal" 
                data-target="#idModalPaginaEdit"
                onclick="modalPaginasEdita(${pagina['pagina']['id']})">
                <i class="far fa-edit"></i>
              </button>
            </td>`;
        } else {
          templete += `
          <td></td>`;
        }
        

        templete += `
        </tr>
        `;
        cont++;
      });
      $('#idTableBodyPaginasList').html(templete);
      $('#idTablePaginasList').DataTable();

    },
    error : function(error){
      console.log(error);
    }
  });
}

function modalPaginasEdita(id){
  //console.log(id);
  $.ajax({
    url : 'BackEnd/Paginas/single.php',
    data : { 'id' : id },
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos[0]);

      $('#idInputPaginaEdit_id').val(datos[0]['pagina']['id']);
      $('#idInputPaginaEdit_fontawesome').val(datos[0]['pagina']['fontawesome']);
      $('#idInputPaginaEdit_nombre').val(datos[0]['pagina']['nombre']);
      $('#idInputPaginaEdit_pagina').val(datos[0]['pagina']['pagina']);

      let templete = ``;
      if(datos[0]['pagina']['menu'] == 1) {
        templete = `
          <option value="1">Si</option>
          <option value="0">No</option>
        `;
      }
      else {
        templete = `
          <option value="0">No</option>
          <option value="1">Si</option>
        `;
      }
      $('#idInputPaginaEdit_menu').html(templete);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function paginaEdit(id, fontawesome, nombre, pagina, menu) {
  //console.log(id);
  $.ajax({
    url : 'BackEnd/Paginas/edit.php',
    data : { 
      'id'          : id,
      'fontawesome' : fontawesome,
      'nombre'      : nombre,
      'pagina'      : pagina,
      'menu'        : menu,
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      Swal.fire(
        'Listo',
        'Editado correcto',
        'success'
      )

      $('#idModalPaginaEdit').modal('hide');
      $('#idFormPaginaEdit').trigger('reset');

      paginaList();
    },
    error : function(error){
      console.log(error);
    }
  });
}

function nivelesList(){
  $.ajax({
    url : 'BackEnd/Usuarios/nivelesList.php',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      let templete = ``;
      let cont = 1;

      datos.forEach(nivelUsr => {
        //console.log(nivelUsr['crud'][0]['crud_pagina']['altas']);
        let idNivelUsr = nivelUsr['nivel']['id'];
        templete += `
        <tr>
          <th scope="row">${cont}</th>
          <td>
            <label class="font-weight-bold text-primary">${nivelUsr['nivel']['nombre']}</label>
            <div id="idDivListPaginasPermitidasNivel_${nivelUsr['nivel']['id']}">
            </div>
          </td>`;

        if(nivelUsr['crud'][0]['crud_pagina']['altas'] == 1) {
          templete += `
          <td>
            <button 
              type="button" 
              class="btn btn-outline-info btn-sm"
              onclick="modalPermisosNivelUsr(${nivelUsr['nivel']['id']}, '${nivelUsr['nivel']['nombre']}')">
              <i class="far fa-check-square"></i>
              </button>
          </td>`;
        } else {
          templete += `
          <td>
          </td>`;
        }
        

        templete += `
        </tr>
        `;
        cont++;
        permisosList(idNivelUsr);
      });

      $('#idTableBodyNivelesUsuarioList').html(templete);
      $('#idTableNivelesUsuario').DataTable();
    },
    error : function(error){
      console.log(error);
    }
  });
}

function modalPermisosNivelUsr(idNivelUsr, nombreNivelUsr){
  
  $('#idModalPermisos').modal('show');
  $('#idLabelNivelPermiso').html(nombreNivelUsr);
  $('#idInputPaginaPermitida_nivelUsr').val(idNivelUsr);

  //console.log(idNivelUsr);
  $.ajax({
    url : 'BackEnd/Paginas/list.php',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      let templete = ``;
      let cont = 1;
      datos.forEach(checkListPagina => {
        templete += `
        <tr>
          <th scope="row text-center" style="text-align:center;">
            ${cont}
          </th>
          <td>
            <div class="form-check">
              <input 
                class="form-check-input" 
                type="checkbox" 
                name="nameInputPaginaPermitida[]"
                value = "${checkListPagina['pagina']['id']}"
                id="idInputPaginaPermitida_${idNivelUsr}_${checkListPagina['pagina']['id']}">
              <label 
                class="form-check-label" 
                for="idInputPaginaPermitida_${idNivelUsr}_${checkListPagina['pagina']['id']}">
                ${checkListPagina['pagina']['pagina']}
              </label>
            </div>
          </td>
        </tr>
        `;
        cont++;
      });

      $('#idTablePaginasBodyPermitidas').html(templete);
      //$('#idTablePaginasPermitidas').DataTable();


      seleccionaCheckListPermitido(idNivelUsr);

    },
    error : function(error){
      console.log(error);
    }
  });
  
}

function seleccionaCheckListPermitido(nivelUsuario){
  //console.log(nivelUsuario, checkboxSeleccionados);
  $.ajax({
    url : 'BackEnd/Permisos/list.php',
    data : { 
      'nivelUsuario'          : nivelUsuario
    },
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      //============= rellena los check seleccionados
      datos.forEach(checkListSeleccionados => {
        let idNivel     = nivelUsuario;
        let idCheckBox  = checkListSeleccionados['pagina']['id_pagina'];
        document.getElementById("idInputPaginaPermitida_"+idNivel+"_"+idCheckBox).checked = true;
      });

    },
    error : function(error){
      console.log(error);
    }
  });
}
