$(function(){
  //console.log('perfil is running...');

  datosPerfil();

  //EDIT PERFIL
  $('#idFormPerfilEdit').submit(function(e){ 
    e.preventDefault();

    let id_especialidad    = $('#idFormPerfilEdit_id_especialidad').val();

    let nombre    = $('#idFormPerfilEdit_nombre').val();
    let apepat    = $('#idFormPerfilEdit_apepat').val();
    let apemat    = $('#idFormPerfilEdit_apemat').val();

    let calle   = $('#idFormPerfilEdit_calle').val();
    let colonia = $('#idFormPerfilEdit_colonia').val();
    let cp      = $('#idFormPerfilEdit_cp').val();
    let pais    = $('#idFormPerfilEdit_pais').val();
    let estado  = $('#idFormPerfilEdit_estado').val();
    let mpio    = $('#idFormPerfilEdit_mpio').val();

    let fechaNac  = $('#idFormPerfilEdit_fecha_nacimiento').val();
    let dato_1  = $('#idFormPerfilEdit_dato_1').val();
    let dato_2  = $('#idFormPerfilEdit_dato_2').val();
    let cv      = ckePerfil_cv.getData();
    

    editDatos(id_especialidad, nombre, apepat, apemat, calle, colonia, cp, pais, estado, mpio, fechaNac, dato_1, dato_2, cv);
  });

  //EDITA CONTRASENA
  $('#idFormPerfilContrasena').submit(function(e){
    e.preventDefault();

    let password_actual    = $('#idCambiarPswActual').val();
    let password_nueva     = $('#idCambiarPswNueva').val();
    let password_nueva_2   = $('#idCambiarPswNueva2').val();

    editPsw(password_actual, password_nueva, password_nueva_2);
  });

  //EDITA FOTO
  $('#idFormPerfilFoto').submit(function(e){
    e.preventDefault();

    let foto    = $('#idPerfilFotoEdita')[0].files[0];

    var formData = new FormData();
    formData.append('foto', foto);

    editFoto(formData);
  });

  //SELECCIONA PAIS Y MUESTRA LISTA ESTADOS
  $('#idFormPerfilEdit_pais').change(function(){
    let idPais = $('#idFormPerfilEdit_pais').val();
    if(idPais != null && idPais != ''){
      catalogo_estados(idPais, '', '---');
    }
  });

  // ======== CV USUARIO ADD
  ClassicEditor
  .create(document.querySelector( '#idFormPerfilEdit_cv'))
  .then(newEditor => { ckePerfil_cv = newEditor; })
  .catch(error => { console.error(error); });
  
});


function datosPerfil(){
  $.ajax({
    url : 'BackEnd/Sesion/mi-sesion.php',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos['sesion']);

      if(datos['existe'] == 1) {
        singleUsuario(datos['sesion']['id']);
      }

      let templete = ``;
      if(datos['sesion']['img'] == null) {
        templete = `
        <i class="far fa-user-circle fa-5x"></i>
        `;
      } else {
        templete = `<img src="img/usuarios/${datos['sesion']['img']}" alt="..." class="img-thumbnail">`;
      }
      $('#idPerfilFoto').html(templete);
      //
    },
    error : function(error) {
      console.log(error);
    }
  });
}

function editDatos(id_especialidad, nombre, apepat, apemat, calle, colonia, cp, pais, estado, mpio, fechaNac, dato_1, dato_2, cv) {
  //console.log(nombre, apepat, apemat, calle, colonia, cp, pais, estado, mpio, fechaNac, dato_1, dato_2);
  $.ajax({
    url : 'BackEnd/Sesion/perfil-datos-edit.php',
    data : {
      'id_especialidad' : id_especialidad,
      'nombre'    : nombre,
      'apepat'    : apepat,
      'apemat'    : apemat,
      'calle'     : calle,
      'colonia'   : colonia,
      'cp'        : cp,
      'pais'      : pais,
      'estado'    : estado,
      'mpio'      : mpio,
      'fechaNac'  : fechaNac,
      'dato_1'    : dato_1,
      'dato_2'    : dato_2,
      'cv'        : cv,
    },
    type : 'POST',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos);

      datosPerfil();

      Swal.fire(
        '¡Listo!',
        'Datos editados correctamente!',
        'success'
      )

    },
    error : function(error) {
      console.log(error);
    }
  });
}

function editPsw(password_actual, password_nueva, password_nueva_2) {
  $.ajax({
    url : 'BackEnd/Sesion/perfil-contrasena-edit.php',
    data : {
      'password_actual'    : password_actual,
      'password_nueva'     : password_nueva,
      'password_nueva_2'   : password_nueva_2,
    },
    type : 'POST',
    success : function(response) {
      let datos = JSON.parse(response);
      console.log(datos);

      if(datos['idPsw'] == 0) {
        Swal.fire(
          'Error!',
          'La contraseña actual no coincide',
          'error'
        )
      } else {
        $('#idModalPerfilContrasena').modal('show');
        Swal.fire(
          'Listo',
          'La contraseña se cambio correctamente',
          'success'
        )
        window.location.href = 'login.html';
      }
    },
    error : function(error) {
      console.log(error);
    }
  });
}

function editFoto(formData) {
  $.ajax({
    url : 'BackEnd/Sesion/perfil-foto-edit.php',
    data : formData,
    type : 'POST',
    contentType : false,
    processData : false,
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      $('#idModalPerfilFoto').modal('hide');
      $('#idFormPerfilFoto').trigger('reset');

      Swal.fire(
        '¡Listo!',
        'Foto de perfil editada correctamente!',
        'success'
      )

      datosPerfil();
    },
    error : function(error){
      console.log(error);
    }
  });
}

function catalogo_paises(idPais, nombrePais){
  $.ajax({
    url : 'BackEnd/Catalogo_2/list.php',
    data : {'idCatalogo1' : 1},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      // ====================== DIRECCCION 1 ======================
      //MUESTRA LISTA DE PAISES
      let templete = `<option value="${idPais}">${nombrePais}</option>`;
      datos.forEach(elemento => {
        //console.log(elemento);
        templete += `
        <option value="${elemento['elemento']['id']}">${elemento['elemento']['nombre']}</option>
        `;
      });
      $('#idFormPerfilEdit_pais').html(templete);

    },
    error : function(error){
      console.log(error);
    }
  });
}

function catalogo_estados(idPais, idEstado, nombreEstado) {
  //console.log(idPais, idEstado, nombreEstado);
  $.ajax({
    url : 'BackEnd/Catalogo_3/list.php',
    data : {'idCatalogo2' : idPais},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      //mmmmmmmmmmmmmmmmmmmmmmm DIRECCION 2 ADD
      let templete = `<option value="${idEstado}">${nombreEstado}</option>`;
      datos.forEach(elemento => {
        templete += `
        <option value="${elemento['elemento']['id']}">${elemento['elemento']['nombre']}</option>
        `;
      });
      $('#idFormPerfilEdit_estado').html(templete);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function singleUsuario(id){
  $.ajax({
    url : 'BackEnd/Usuarios/single.php',
    data : {'id' : id},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos[0]['especialidad']);
      //console.log(datos[0]['pais']);

      $('#idFormPerfilEdit_nombre').val(datos[0]['usuario']['nombre']);
      $('#idFormPerfilEdit_apepat').val(datos[0]['usuario']['apepat']);
      $('#idFormPerfilEdit_apemat').val(datos[0]['usuario']['apemat']);

      $('#idFormPerfilEdit_calle').val(datos[0]['usuario']['calle']);
      $('#idFormPerfilEdit_colonia').val(datos[0]['usuario']['colonia']);
      $('#idFormPerfilEdit_cp').val(datos[0]['usuario']['cp']);
      $('#idFormPerfilEdit_mpio').val(datos[0]['usuario']['mpio']);

      let paisId      = 0;
      let paisNombre  = '---';
      if(datos[0]['pais'] != null){
        paisId      = datos[0]['pais']['id'];
        paisNombre  = datos[0]['pais']['nombre'];
      }

      let estadoId      = 0;
      let estadoNombre  = '---';
      if(datos[0]['estado'] != null){
        estadoId      = datos[0]['estado']['id'];
        estadoNombre  = datos[0]['estado']['nombre'];
      }

      catalogo_paises(paisId, paisNombre);
      catalogo_estados(paisId, estadoId, estadoNombre);

      $('#idFormPerfilEdit_fecha_nacimiento').val(datos[0]['usuario']['fecha_nacimiento']);
      $('#idFormPerfilEdit_dato_1').val(datos[0]['usuario']['dato_1']);
      $('#idFormPerfilEdit_dato_2').val(datos[0]['usuario']['dato_2']);

      let cv = datos[0]['usuario']['cv'];
      if(cv != null) {
        ckePerfil_cv.setData(cv);
      } else {
        ckePerfil_cv.setData('');
      }

    },
    error : function(error){
      console.log(error);
    }
  });
}
