$(function(){
  console.log('paquetes is running...');

  allowCrud(26);
  paquetes_list();
  paquetes_caracteristicas_list();

  //======= ADD PAQUETE
  $('#idFormPaqueteAdd').submit(function(e){
    e.preventDefault();
    
    let costo       = $('#idInputPaqueteAdd_costo').val();
    let nombre      = $('#idInputPaqueteAdd_nombre').val();
    let descripcion = $('#idInputPaqueteAdd_descripcion').val();
    
    paquetes_add(costo, nombre, descripcion);
  });

  //======= EDIT PAQUETE
  $('#idFormPaqueteEdit').submit(function(e){
    e.preventDefault();
    let id          = $('#idInputPaqueteEdit_id').val();
    let costo       = $('#idInputPaqueteEdit_costo').val();
    let nombre      = $('#idInputPaqueteEdit_nombre').val();
    let descripcion = $('#idInputPaqueteEdit_descripcion').val();

    paquetes_edit(id, costo, nombre, descripcion);
  });

  //======= ADD/EDIT PAQUETE CARACTERISTICA
  $('#idFormCaracteristica').submit(function(e){
    e.preventDefault();
    let id          = $('#idInputCaracteristicaAdd_id').val();
    let nombre      = $('#idInputCaracteristicaAdd_nombre').val();
    let descripcion = $('#idInputCaracteristicaAdd_descripcion').val();

    if(!id) {
      paquetes_caracteristica_add(nombre, descripcion);
    } else {
      paquetes_caracteristica_edit(id, nombre, descripcion);
    }
  });

  //
  $('#idFormMisCaracteristicas').submit(function(e){
    e.preventDefault();

    let idPaquete             = $('#idInputCatacteristica_id').val();
    let allCheckbox           = document.getElementsByName('nameInputCaracteristica[]');
    var allCheckboxLength     = allCheckbox.length;  
    let checkboxSeleccionados = [];
    
    let i;
    for(i = 0; i < allCheckboxLength; i++){
      if(allCheckbox[i].checked) {
        //console.log(allCheckbox[i].id);
        checkboxSeleccionados.push($('#'+allCheckbox[i].id).val());
      }
    } 

    paquete_caracteristicas_add(idPaquete, checkboxSeleccionados);
  });
});

function allowCrud(idPagina) {
  //console.log(idPagina);
  $.ajax({
    url : 'BackEnd/Permisos/crud-allow.php',
    data : {'idPagina' : idPagina},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos[0]['crud_pagina']);

      let templeteC = ``;

      if(datos[0]['crud_pagina']['altas'] == 1) {
        templeteC = `
          <button 
            type="button" 
            class="d-none d-sm-inline-block btn btn-sm btn-primary btn-block shadow-sm classCrud-Add"
            data-toggle="modal" data-target="#idModalCaracteristica_Add">
            <i class="fas fa-plus"></i> Caracteristica
          </button>
          `;
      } 
      $('#idDivNuevaCaracteristica').html(templeteC);

      if(datos[0]['crud_pagina']['altas'] == 1) {
        templete = `
          <button 
            type="button" 
            class="d-none d-sm-inline-block btn btn-sm btn-primary btn-block shadow-sm classCrud-Add"
            data-toggle="modal" data-target="#idModalPaquete_Add">
            <i class="fas fa-plus"></i> Paquete
          </button>
          `;
      } 
      $('#idDivNuevoPaquete').html(templete);

    },
    error : function(error){
      console.log(error);
    }

  });
}

function paquetes_add(costo, nombre, descripcion){
  console.log(costo, nombre, descripcion);
  $.ajax({
    url : 'BackEnd/Paquetes/add.php',
    data : {
      'costo'       : costo, 
      'nombre'      : nombre, 
      'descripcion' : descripcion
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      console.log(datos);
      $('#idFormPaqueteAdd').trigger('reset');
      $('#idModalPaquete_Add').modal('hide');

      Swal.fire(
        '¡Listo!',
        '¡Insertado correctamente!',
        'success'
      )
      paquetes_list();
    },
    error : function(error){
      console.log(error);
    }
  });
}

function paquetes_list(){
  $.ajax({
    url : 'BackEnd/Paquetes/list.php',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      let templete = ``;
      let contador = 1;

      datos.forEach(function(registro, index){
        //console.log(registro['usuarios'].length);
        let usrsPaquete = registro['usuarios'].length;
        templete += `
          <div class="col-12 col-sm-12 col-md-6 col-lg-4 col-xl-4 p-2">
            <div class="card">
              <div class="card-header">
                <label class="font-weight-bold">${registro['paquete']['nombre']}</label>`;

        if(usrsPaquete == 0 ){
          templete += `
            <button 
              type="button" 
              class="btn btn-danger btn-sm m-1" 
              style="float: right;"
              onclick="paquetes_delete(${registro['paquete']['id']})">
              <i class="fas fa-times"></i>
            </button>`;
        }

        templete += `
                <button 
                  type="button" 
                  class="btn btn-warning btn-sm m-1" 
                  style="float: right;"
                  onclick="paquetes_modal(${registro['paquete']['id']})">
                  <i class="far fa-edit"></i>
                </button>
              </div>
              <div class="card-body">
                <h4><i class="far fa-money-bill-alt"></i> $${registro['paquete']['costo']}.00</h4>
                <h4><i class="fas fa-users"></i> ${usrsPaquete}</h4>
                <p class="card-text">
                  ${(registro['paquete']['descripcion'] == null) ? 'Sin descripción' : registro['paquete']['descripcion']}
                </p>
                <button  
                  type="button" 
                  class="btn btn-primary"
                  data-toggle="modal" 
                  data-target="#idModalMisCaracteristicas"
                  onclick="modaMisCaracteristicas(${registro['paquete']['id']});">
                  Caracteristicas
                </a>
              </div>
            </div>
          </div>
          `;
      });

      $('#idDivPaquetes').html(templete);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function modaMisCaracteristicas(idPaquete){
  $('#idInputCatacteristica_id').val(idPaquete)
  caracteristicas_seleccionadas(idPaquete);
}

function caracteristicas_seleccionadas(idPaquete){
  $.ajax({
    url : 'BackEnd/Paquetes/paquete_caracteristicas_relacionadas.php',
    data : {'idPaquete' : idPaquete},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      // console.log(datos);
      // console.log(datos['caracteristicas']);
      // console.log(datos['mis_caracteristicas']);

      let arrayCaracteristicas    = datos['caracteristicas'];
      let arrayMisCaracteristicas = datos['mis_caracteristicas'];

      //limpia todos los check
      arrayCaracteristicas.forEach(function(caracteristicas, idx) {
        document.getElementById('idInputCatacteristica_'+caracteristicas['caracteristicas']['id']).checked = false;;
      });

      //llena los check seleccionados
      arrayMisCaracteristicas.forEach(function(miCaracteristicas, idx) {
        document.getElementById('idInputCatacteristica_'+miCaracteristicas['mi_caracteristica']['id_caracteristica']).checked = true;;
      });

    },
    error : function(error){
      console.log(error);
    }
  });
}

function paquetes_modal(id){
  //console.log('modal id: '+id);
  $.ajax({
    url : 'BackEnd/Paquetes/single.php',
    data : {'id' : id},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);
      $('#idModalPaquete_Edit').modal('show');

      $('#idInputPaqueteEdit_id').val(id);
      $('#idInputPaqueteEdit_costo').val(datos['elemento']['costo']);
      $('#idInputPaqueteEdit_nombre').val(datos['elemento']['nombre']);
      $('#idInputPaqueteEdit_descripcion').val(datos['elemento']['descripcion']);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function paquetes_edit(id, costo, nombre, descripcion){
  $.ajax({
    url : 'BackEnd/Paquetes/edit.php',
    data : {
      'id'          : id, 
      'costo'       : costo, 
      'nombre'      : nombre, 
      'descripcion' : descripcion
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      $('#idFormPaqueteEdit').trigger('reset');
      $('#idModalPaquete_Edit').modal('hide');

      Swal.fire(
        '¡Listo!',
        'Editado correctamente!',
        'success'
      );

      paquetes_list();
    },
    error : function(error){
      console.log(error);
    }
  });
}

function paquetes_delete(id){

  Swal.fire({
    title: '¿Estas seguro?',
    text: "¡No podrás revertir esto!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: '¡Si, borrarlo!'
  }).then((result) => {
    if (result.isConfirmed) {

      $.ajax({
        url : 'BackEnd/Paquetes/delete.php',
        data : {'id' : id},
        type : 'GET',
        success : function(response){
          //console.log(response);
          paquetes_list();
        },
        error : function(error){
          console.log(error);
        }
      });

    }
  })



}

function paquetes_caracteristica_add(nombre, descripcion){
  console.log('Agrega caracteristica');
  $.ajax({
    url : 'BackEnd/Paquetes/caracteristicas_add.php',
    data : {'nombre' : nombre, 'descripcion' : descripcion},
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      console.log(datos);
      $('#idFormCaracteristica').trigger('reset');

      Swal.fire(
        '¡Listo!',
        '¡Insertado correctamente!',
        'success'
      )
      paquetes_caracteristicas_list();
    },
    error : function(error){
      console.log(error);
    }
  });
}

function paquetes_caracteristica_edit(id, nombre, descripcion){
  console.log('Edita caracteristica');
  $.ajax({
    url : 'BackEnd/Paquetes/caracteristicas_edit.php',
    data : {'id' : id, 'nombre' : nombre, 'descripcion' : descripcion},
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      $('#idFormCaracteristica').trigger('reset');
      $('#idSubmitFormCaracteristica').html('Agregar');
      $('#idSubmitFormCaracteristica').attr('class', 'btn btn-primary btn-sm');

      Swal.fire(
        '¡Listo!',
        'Editado correctamente!',
        'success'
      );

      paquetes_list();
      paquetes_caracteristicas_list();
    },
    error : function(error){
      console.log(error);
    }
  });
}

function paquetes_caracteristicas_list(){
  $.ajax({
    url : 'BackEnd/Paquetes/caracteristicas_list.php',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      let templete = ``;
      let contador = 1;

      datos.forEach(function(registro, index){
        //console.log(registro['paquete']);
        templete += `
          <tr>
            <th scope="row">${contador}</th>
            <td>${registro['paquete_caracteristica']['nombre']}</td>
            <td>${registro['paquete_caracteristica']['descripcion']}</td>
            <td>
              <button 
                type="button" 
                class="btn btn-warning btn-sm"
                onclick="paquetes_caracteristicas_modal(${registro['paquete_caracteristica']['id']})">
                <i class="far fa-edit"></i>
              </button>
            </td>
          </tr>
          `;
          contador++;
      });
      $('#idTableBodyPaquetesCaracteristicas').html(templete);

      let templete2 = ``;
      let cont = 1;
      datos.forEach(caracteristica => {
        templete2 += `
        <div class="form-check">
          <input 
            class="form-check-input" 
            type="checkbox" 
            value="${caracteristica['paquete_caracteristica']['id']}" 
            id="idInputCatacteristica_${caracteristica['paquete_caracteristica']['id']}"
            name="nameInputCaracteristica[]">
          <label 
            class="form-check-label" 
            for="idInputCatacteristica_${caracteristica['paquete_caracteristica']['id']}">
            ${caracteristica['paquete_caracteristica']['nombre']}
          </label>
        </div>
        `;
        cont++;
      });
      $('#idModalBodyMisCaracteristicas').html(templete2);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function paquetes_caracteristicas_modal(id){
  //console.log(id);
  $.ajax({
    url: 'BackEnd/Paquetes/caracteristicas_single.php',
    data : {'id' : id},
    type : 'GET',
    success: function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      let nombre      = datos['elemento']['nombre'];
      let descripcion = datos['elemento']['descripcion'];

      $('#idInputCaracteristicaAdd_id').val(id);
      $('#idInputCaracteristicaAdd_nombre').val(nombre);
      $('#idInputCaracteristicaAdd_descripcion').val(descripcion);

      $('#idSubmitFormCaracteristica').html('<i class="far fa-edit"></i> Editar');
      $('#idSubmitFormCaracteristica').attr('class', 'btn btn-warning btn-sm');

    },
    error : function(error){
      console.log(error);
    }
  });
}

function valorBoton(){
  $('#idSubmitFormCaracteristica').html('<i class="fas fa-plus"></i> Agregar');
  $('#idSubmitFormCaracteristica').attr('class', 'btn btn-primary btn-sm');
}

function paquete_caracteristicas_add(idPaquete, checkboxSeleccionados){
  //console.log(idPaquete, checkboxSeleccionados);
  $.ajax({
    url : 'BackEnd/Paquetes/paquete_caracteristica_relacionadas_add.php',
    data : {
      'idPaquete'             : idPaquete, 
      'checkboxSeleccionados' : checkboxSeleccionados
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);
      $('#idModalMisCaracteristicas').modal('hide');

      $('#idFormMisCaracteristicas').trigger('reset');
      Swal.fire(
        '¡Listo!',
        'Caracteristicas guardadas correctamente!',
        'success'
      )
    },
    error : function(error){
      console.log(error);
    }
  });
}

