let idNivel1 = localStorage.getItem("idNivel1");
let nombreNivel1 = localStorage.getItem("nombreNivel1");

let idNivel2 = localStorage.getItem("idNivel2");
let nombreNivel2 = localStorage.getItem("nombreNivel2");

let idNivel3 = localStorage.getItem("idNivel3");
let nombreNivel3 = localStorage.getItem("nombreNivel3");

$(function(){
  //console.log('nivel_3 is running...');
  breadcrumb();
  consulta(idNivel3);

  $('#idFormAddNivel4').submit(function(e){
    e.preventDefault();
    let id_nivel_1    = idNivel1;
    let id_nivel_2    = idNivel2;
    let id_nivel_3    = idNivel3;
    let nombre        = $('#idNombre_add_n4').val();
    let descripcion   = $('#idDescripcion_add_n4').val();
    let bg            = $('#idBg_add_n4').val();
    let bg_archivo    = $('#idBg_add_n4')[0].files[0];
    let ico           = $('#idIco_add_n4').val();
    let ico_archivo   = $('#idIco_add_n4')[0].files[0];
    let fa            = $('#idFa_add_n4').val();

    //console.log('id_nivel_1: '+id_nivel_1+' id_nivel_2: '+id_nivel_2+' id_nivel_3: '+id_nivel_3+' nombre: '+nombre+' descripcion: '+descripcion+' bg: '+bg+' bg_archivo: '+bg_archivo+' ico: '+ico+' ico_archivo: '+ico_archivo+' fa: '+fa);

    var formData = new FormData();
    formData.append('id_nivel_1', id_nivel_1);
    formData.append('id_nivel_2', id_nivel_2);
    formData.append('id_nivel_3', id_nivel_3);
    formData.append('nombre', nombre);
    formData.append('descripcion', descripcion);
    formData.append('bg', bg);
    formData.append('bg_archivo', bg_archivo);
    formData.append('ico', ico);
    formData.append('ico_archivo', ico_archivo);
    formData.append('fa', fa);

    alta(formData);
    
  });

  $('#idFormEditNivel4').submit(function(e){
    e.preventDefault();

    let id            = $('#idNivel4').val();
    let nombre        = $('#idNombre_edit_n4').val();
    let descripcion   = $('#idDescripcion_edit_n4').val();
    let bg            = $('#idBg_edit_n4').val();
    let bg_archivo    = $('#idBg_edit_n4')[0].files[0];
    let bg_respaldo   = $('#idBg_edit_n4_respaldo').val();
    let ico           = $('#idIco_edit_n4').val();
    let ico_archivo   = $('#idIco_edit_n4')[0].files[0];
    let ico_respaldo  = $('#idIco_edit_n4_respaldo').val();
    let fa            = $('#idFa_edit_n4').val();

    //console.log('id: '+id+' nombre: '+nombre+' descripcion: '+descripcion+' bg: '+bg+' bg_archivo: '+bg_archivo+' bg_respaldo: '+bg_respaldo+' ico: '+ico+' ico_archivo: '+ico_archivo+' ico_respaldo: '+ico_respaldo+' fa: '+fa);

    var formData = new FormData();
    formData.append('id', id);
    formData.append('nombre', nombre);
    formData.append('descripcion', descripcion);
    formData.append('bg', bg);
    formData.append('bg_archivo', bg_archivo);
    formData.append('bg_respaldo', bg_respaldo);
    formData.append('ico', ico);
    formData.append('ico_archivo', ico_archivo);
    formData.append('ico_respaldo', ico_respaldo);
    formData.append('fa', fa);

    modificacion(formData);
    
  });

  //14 id pagina nivel_4.html en la tabla g13_paginas
  allowCrud(14);
});

function allowCrud(idPagina) {
  //console.log(idPagina);
  $.ajax({
    url : 'BackEnd/Permisos/crud-allow.php',
    data : {'idPagina' : idPagina},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      console.log(datos[0]['crud_pagina']['altas']);

      let templete = ``;

      if(datos[0]['crud_pagina']['altas'] == 1) {
        templete = `
        <a 
          href="#" 
          class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"
          data-toggle="modal" data-target="#idModalAddNivel4">
          <i class="fas fa-plus"></i> Agregar
        </a>`;
      } 
      $('#idDivNivel_add').html(templete);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function alta(formData){
  $.ajax({
    url : 'BackEnd/Nivel_4/add.php',
    data : formData,
    type : 'POST',
    contentType : false,
    processData : false,
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);
      $('#idModalAddNivel4').modal('hide');
      $('#idFormAddNivel4').trigger('reset');
      consulta(idNivel3);

      Swal.fire(
        '¡Listo!',
        '¡Insertado correctamente!',
        'success'
      )

    },
    error : function(error){
      console.log(error);
    }
  });
}

function consulta(idN3){
  $.ajax({
    url : 'BackEnd/Nivel_4/list.php',
    data : {'idN3' : idN3},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      let templete = '';
      let cont = 1;

      datos.forEach(function(elemento, idx) {

        // console.log(elemento['crud'][0]['crud_pagina']['altas']);
        // console.log(elemento['crud'][0]['crud_pagina']['bajas']);
        // console.log(elemento['crud'][0]['crud_pagina']['modificaciones']);
        // console.log(elemento['crud'][0]['crud_pagina']['consultas']);

        templete += `
        <tr>
          <th scope="row">${cont}</th>
          <td>
            <i class="${elemento['nivel_4']['fa']}"></i>  
            ${elemento['nivel_4']['nombre']} - <small>(Id.${elemento['nivel_4']['id']})</small>
          </td>`;
        

        //BAJAS
        if(elemento['crud'][0]['crud_pagina']['bajas'] == 1){
          templete += `
            <td>
              <button 
                type="button" 
                class="btn btn-outline-dark btn-sm"
                onclick="baja(${elemento['nivel_4']['id']});">
                <i class="far fa-trash-alt"></i>
              </button>
            </td>`;
        } else {
          templete += `
            <td>
            </td>`;
        }

        //MODIFICACIONES
        if(elemento['crud'][0]['crud_pagina']['modificaciones'] == 1){
          templete += `
            <td>
              <button 
                type="button" 
                class="btn btn-outline-dark btn-sm"
                onclick="modalSingleNivel_4(${elemento['nivel_4']['id']});">
                <i class="far fa-edit"></i>
              </button>
            </td>`;
        } else {
          templete +=`
            <td>
            </td>`;
        }


        templete += `
        </tr>
        `;
        cont++;
      });
      $('#idTablaCuerpoNivel4').html(templete)
    },
    error : function(error){
      console.log(error);
    }
  });
}

function modalSingleNivel_4(id){
  $.ajax({
    url : 'BackEnd/Nivel_4/single.php',
    data : {'id' : id},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);
      
      $('#idModalEditNivel4').modal('show');

      $('#idNivel4').val(datos['nivel_4']['id']);
      $('#idBg_edit_n4_respaldo').val(datos['nivel_4']['bg']);
      $('#idIco_edit_n4_respaldo').val(datos['nivel_4']['ico']);
      $('#idNombre_edit_n4').val(datos['nivel_4']['nombre']);
      $('#idDescripcion_edit_n4').val(datos['nivel_4']['descripcion']);
      $('#idShowImgBG_Edit').attr('src', 'img/nivel_4/'+datos['nivel_4']['bg']);
      $('#idShowImgICO_Edit').attr('src', 'img/nivel_4/'+datos['nivel_4']['ico']);
      $('#idFa_edit_n4').val(datos['nivel_4']['fa']);
      
    },
    error : function(error){
      console.log(error);
    }
  });
}

function modificacion(formData){
  //console.log(formData);

  $.ajax({
    url : 'BackEnd/Nivel_4/edit.php',
    data : formData,
    type : 'POST',
    contentType : false,
    processData : false,
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);
      $('#idModalEditNivel4').modal('hide');
      $('#idFormEditNivel4').trigger('reset');
      consulta(idNivel3);

      Swal.fire(
        '¡Listo!',
        'Editado correctamente!',
        'success'
      )
    },
    error : function(error){
      console.log(error);
    }
  });

}

function baja(id){

  Swal.fire({
    title: '¿Estas seguro?',
    text: "¡No podrás revertir esto!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: '¡Si, borrarlo!'
  }).then((result) => {
    if (result.isConfirmed) {

      $.ajax({
        url : 'BackEnd/Nivel_4/delete.php',
        data : {'id' : id},
        type : 'POST',
        success : function(response){
          console.log(response);
          consulta(idNivel3);

          Swal.fire(
            '¡Eliminado!',
            'Tu registro ha sido eliminado.',
            'success'
          )
        },
        error : function(error){
          console.log(error);
        }
      });
    }
  })
}

function breadcrumb(){
  let templete = `
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="nivel_1.html">${nombreNivel1} - <small>(Id.${idNivel1})</small></a></li>
    <li class="breadcrumb-item"><a href="nivel_2.html">${nombreNivel2} - <small>(Id.${idNivel2})</small></a></li>
    <li class="breadcrumb-item"><a href="nivel_3.html">${nombreNivel3} - <small>(Id.${idNivel3})</small></a></li>
  </ol>
  `;
  $('#idBreadCrumb').html(templete);
}