let idNivel1 = localStorage.getItem("idNivel1");
let nombreNivel1 = localStorage.getItem("nombreNivel1");

let idNivel2 = localStorage.getItem("idNivel2");
let nombreNivel2 = localStorage.getItem("nombreNivel2");

$(function(){
  //console.log('nivel_2 is running...');
  breadcrumb();
  consulta(idNivel2);

  $('#idFormAddNivel3').submit(function(e){
    e.preventDefault();
    let id_nivel_1    = idNivel1;
    let id_nivel_2    = idNivel2;
    let nombre        = $('#idNombre_add_n3').val();
    let descripcion   = $('#idDescripcion_add_n3').val();
    let bg            = $('#idBg_add_n3').val();
    let bg_archivo    = $('#idBg_add_n3')[0].files[0];
    let ico           = $('#idIco_add_n3').val();
    let ico_archivo   = $('#idIco_add_n3')[0].files[0];
    let fa            = $('#idFa_add_n3').val();

    //console.log('nombre: '+nombre+' descripcion: '+descripcion+' bg: '+bg+' bg_archivo: '+bg_archivo+' ico: '+ico+' ico_archivo: '+ico_archivo+' fa: '+fa);

    var formData = new FormData();
    formData.append('id_nivel_1', id_nivel_1);
    formData.append('id_nivel_2', id_nivel_2);
    formData.append('nombre', nombre);
    formData.append('descripcion', descripcion);
    formData.append('bg', bg);
    formData.append('bg_archivo', bg_archivo);
    formData.append('ico', ico);
    formData.append('ico_archivo', ico_archivo);
    formData.append('fa', fa);

    alta(formData);
  });

  $('#idFormEditNivel3').submit(function(e){
    e.preventDefault();

    let id            = $('#idNivel3').val();
    let nombre        = $('#idNombre_edit_n3').val();
    let descripcion   = $('#idDescripcion_edit_n3').val();
    let bg            = $('#idBg_edit_n3').val();
    let bg_archivo    = $('#idBg_edit_n3')[0].files[0];
    let bg_respaldo   = $('#idBg_edit_n3_respaldo').val();
    let ico           = $('#idIco_edit_n3').val();
    let ico_archivo   = $('#idIco_edit_n3')[0].files[0];
    let ico_respaldo  = $('#idIco_edit_n3_respaldo').val();
    let fa            = $('#idFa_edit_n3').val();

    console.log('nombre: '+nombre+' descripcion: '+descripcion+' bg: '+bg+' bg_archivo: '+bg_archivo+' bg_respaldo: '+bg_respaldo+' ico: '+ico+' ico_archivo: '+ico_archivo+' ico_respaldo: '+ico_respaldo+' fa: '+fa);

    var formData = new FormData();
    formData.append('id', id);
    formData.append('nombre', nombre);
    formData.append('descripcion', descripcion);
    formData.append('bg', bg);
    formData.append('bg_archivo', bg_archivo);
    formData.append('bg_respaldo', bg_respaldo);
    formData.append('ico', ico);
    formData.append('ico_archivo', ico_archivo);
    formData.append('ico_respaldo', ico_respaldo);
    formData.append('fa', fa);

    modificacion(formData);
  });

  //13 id pagina nivel_3.html en la tabla g13_paginas
  allowCrud(13);
});

function allowCrud(idPagina) {
  //console.log(idPagina);
  $.ajax({
    url : 'BackEnd/Permisos/crud-allow.php',
    data : {'idPagina' : idPagina},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      console.log(datos[0]['crud_pagina']['altas']);

      let templete = ``;

      if(datos[0]['crud_pagina']['altas'] == 1) {
        templete = `
        <a 
          href="#" 
          class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm"
          data-toggle="modal" data-target="#idModalAddNivel3">
          <i class="fas fa-plus"></i> Agregar
        </a>`;
      } 
      $('#idDivNivel_add').html(templete);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function alta(formData){
  $.ajax({
    url : 'BackEnd/Nivel_3/add.php',
    data : formData,
    type : 'POST',
    contentType : false,
    processData : false,
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);
      $('#idModalAddNivel3').modal('hide');
      $('#idFormAddNivel3').trigger('reset');
      consulta(idNivel2);

      Swal.fire(
        '¡Listo!',
        '¡Insertado correctamente!',
        'success'
      )

    },
    error : function(error){
      console.log(error);
    }
  });
}

function consulta(idN2){
  $.ajax({
    url : 'BackEnd/Nivel_3/list.php',
    data : {'idN2' : idN2},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      let templete = '';
      let cont = 1;

      datos.forEach(function(elemento, idx) {
        // console.log(elemento['crud'][0]['crud_pagina']['altas']);
        // console.log(elemento['crud'][0]['crud_pagina']['bajas']);
        // console.log(elemento['crud'][0]['crud_pagina']['modificaciones']);
        // console.log(elemento['crud'][0]['crud_pagina']['consultas']);
        templete += `
        <tr>
          <th scope="row">${cont}</th>
          <td>
            <i class="${elemento['nivel_3']['fa']}"></i>  
            ${elemento['nivel_3']['nombre']} - <small>(Id.${elemento['nivel_3']['id']})</small>
          </td>`;


        //BAJAS
        if(elemento['crud'][0]['crud_pagina']['bajas'] == 1){
          templete += `
            <td>
              <button 
                type="button" 
                class="btn btn-outline-dark btn-sm"
                onclick="baja(${elemento['nivel_3']['id']});">
                <i class="far fa-trash-alt"></i>
              </button>
            </td>`;
        } else {
          templete += `
            <td>
            </td>`;
        }


        //MODIFICACIONES
        if(elemento['crud'][0]['crud_pagina']['modificaciones'] == 1){
          templete += `
            <td>
              <button 
                type="button" 
                class="btn btn-outline-dark btn-sm"
                onclick="modalSingleNivel_3(${elemento['nivel_3']['id']});">
                <i class="far fa-edit"></i>
              </button>
            </td>`;
        } else {
          templete +=`
            <td>
            </td>`;
        }


        templete += `
          <td>
            <button 
              type="button" 
              class="btn btn-outline-dark btn-sm"
              onclick="irNivel4(${elemento['nivel_3']['id']}, '${elemento['nivel_3']['nombre']}')">
              <i class="fas fa-long-arrow-alt-right"></i>
            </button>
          </td>`;
        
        templete += `
        </tr>
        `;
        cont++;
      });
      $('#idTablaCuerpoNivel3').html(templete)
    },
    error : function(error){
      console.log(error);
    }
  });
}

function modalSingleNivel_3(id){
  $.ajax({
    url : 'BackEnd/Nivel_3/single.php',
    data : {'id' : id},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);
      
      $('#idModalEditNivel3').modal('show');

      $('#idNivel3').val(datos['nivel_3']['id']);
      $('#idBg_edit_n3_respaldo').val(datos['nivel_3']['bg']);
      $('#idIco_edit_n3_respaldo').val(datos['nivel_3']['ico']);
      $('#idNombre_edit_n3').val(datos['nivel_3']['nombre']);
      $('#idDescripcion_edit_n3').val(datos['nivel_3']['descripcion']);
      $('#idShowImgBG_Edit').attr('src', 'img/nivel_3/'+datos['nivel_3']['bg']);
      $('#idShowImgICO_Edit').attr('src', 'img/nivel_3/'+datos['nivel_3']['ico']);
      $('#idFa_edit_n3').val(datos['nivel_3']['fa']);
      
    },
    error : function(error){
      console.log(error);
    }
  });
}

function modificacion(formData){
  console.log(formData);

  $.ajax({
    url : 'BackEnd/Nivel_3/edit.php',
    data : formData,
    type : 'POST',
    contentType : false,
    processData : false,
    success : function(response){
      let datos = JSON.parse(response);
      console.log(datos);
      $('#idModalEditNivel3').modal('hide');
      $('#idFormEditNivel3').trigger('reset');
      consulta(idNivel2);

      Swal.fire(
        '¡Listo!',
        'Editado correctamente!',
        'success'
      )

    },
    error : function(error){
      console.log(error);
    }
  });

}

function baja(id){

  Swal.fire({
    title: '¿Estas seguro?',
    text: "¡No podrás revertir esto!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: '¡Si, borrarlo!'
  }).then((result) => {
    if (result.isConfirmed) {

      $.ajax({
        url : 'BackEnd/Nivel_3/delete.php',
        data : {'id' : id},
        type : 'POST',
        success : function(response){
          console.log(response);
          consulta(idNivel2);

          Swal.fire(
            '¡Eliminado!',
            'Tu registro ha sido eliminado.',
            'success'
          )
        },
        error : function(error){
          console.log(error);
        }
      });

      
    }
  })
}

function irNivel4(id, nombre){
  localStorage.setItem("idNivel3", id);
  localStorage.setItem("nombreNivel3", nombre);
  window.location.href = "nivel_4.html";
}

function breadcrumb(){
  let templete = `
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="nivel_1.html">${nombreNivel1} - <small>(Id.${idNivel1})</small></a></li>
    <li class="breadcrumb-item"><a href="nivel_2.html">${nombreNivel2} - <small>(Id.${idNivel2})</small></a></li>
  </ol>
  `;
  $('#idBreadCrumb').html(templete);
}