$(function(){
  console.log('mis venedores is running...');

  $('#idFormBuscar').submit(function(e){
    e.preventDefault();

    let tipo = $('#idInputBuscar_tipo').val();
    let contenido = $('#idInputBuscar_contenido').val();

    buscar_vendedores(tipo, contenido);
  });

  $('#idInputBuscar_tipo').change(function(){
    $('#idInputBuscar_contenido').val('');
  });

  mis_vendedores();
});

function buscar_vendedores(tipo, contenido){
  //console.log('busca');

  let contenidoId     = '';
  let contenidoUsr    = '';
  let contenidoNombre = '';
  if(tipo == 1){
    contenidoId     = contenido;
    contenidoUsr    = '';
    contenidoNombre = '';
  }
  else if(tipo == 2){
    contenidoId     = '';
    contenidoUsr    = contenido;
    contenidoNombre = '';
  }
  else {
    contenidoId     = '';
    contenidoUsr    = '';
    contenidoNombre = contenido;
  }
  /*
  console.log(contenidoId);
  console.log(contenidoUsr);
  console.log(contenidoNombre);
  */
  $.ajax({
    url : 'BackEnd/Usuarios/list.php',
    data : {
      'id'      : contenidoId,
      'usuario' : contenidoUsr,
      'nombre'  : contenidoNombre,
      'id_nivel' : 21
    },
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);

      $('#idModalVendedores').modal('show');
      let templete = ``;
      let contador = 1;
      datos.forEach(elemento => {

        let nombre = (elemento['usuario']['nombre'] != null) ? elemento['usuario']['nombre'] : '';
        let apepat = (elemento['usuario']['apepat'] != null) ? elemento['usuario']['apepat'] : '';
        let apemat = (elemento['usuario']['apemat'] != null) ? elemento['usuario']['apemat'] : '';
        let fullName = nombre+' '+apepat+' '+apemat;
        templete += `
          <tr>
            <th scope="row">${contador}</th>
            <td>
              ${fullName} <small><b>Id.${elemento['usuario']['id']}</b></small><br>
              <small>${elemento['usuario']['usr']}</small>
            </td>
            <td>
              <button 
                type="button" 
                class="btn btn-outline-primary btn-sm"
                onclick="vendedor_add(${elemento['usuario']['id']}, '${fullName}')">
                <i class="fas fa-plus"></i>
              </button>
            </td>
          </tr>
        `;
        contador++;
      });
      $('#idTablaBodyVendedores').html(templete);
    },
    error : function(error){
      console.log(error);
    }
  });
}
function vendedor_add(id_vendedor, nombre){
  Swal.fire({
    title: '¿Agregar a tu lista de vendedores?',
    text: nombre+" tendra acceso a tus productos",
    icon: 'question',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Si, agregar',
    cancelButtonText: 'No, cancelar'
  }).then((result) => {
    if (result.isConfirmed) {

      $.ajax({
        url : 'BackEnd/Usuarios/vendedor_add.php',
        data : {'id_vendedor' : id_vendedor},
        type : 'POST',
        success : function(response){
          let datos = JSON.parse(response);
          //console.log(datos[0]);

          $('#idModalVendedores').modal('hide');
          $('#idFormBuscar').trigger('reset');

          if(datos[0]['estatus'] == 1){
            Swal.fire(
              'Listo',
              'Vendedor agregado exitosamente.',
              'success'
            )
          }
          else {
            Swal.fire(
              'Error',
              'El vendedor ya existe en mi lista',
              'error'
            )
          }
          mis_vendedores();
        },
        error : function(error){
          console.log(error);
        }
      });
    }
  })
}
function mis_vendedores(){
  $.ajax({
    url : 'BackEnd/Usuarios/vendedores_mi_lista.php',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      let templete = '';
      let contador = 1;
      datos.forEach(element => {
        //console.log(element['vendedor']);

        let nombre = (element['vendedor']['nombre'] != null) ? element['vendedor']['nombre'] : '';
        let apepat = (element['vendedor']['apepat'] != null) ? element['vendedor']['apepat'] : '';
        let apemat = (element['vendedor']['apemat'] != null) ? element['vendedor']['apemat'] : '';
        let fullName = nombre+' '+apepat+' '+apemat;

        templete += `
          <tr>
            <th scope="row">${contador}</th>
            <td>
              ${fullName} <small><b>Id.${element['vendedor']['id']}</b></small><br>
              <small>${element['vendedor']['usr']}</small>
            </td>
            <td>
              <button 
                type="button" 
                class="btn btn-outline-danger btn-sm"
                onclick="vendedor_delete(${element['vendedor']['empresa_id']})">
                <i class="far fa-trash-alt"></i>
              </button>
            </td>
          </tr>
        `;
        contador++;
      });
      $('#idTableBodyMisVendedore').html(templete);
    },
    error : function(error){
      console.log(error);
    }
  });
}
function vendedor_delete(id){
  Swal.fire({
    title: '¿Eliminar vendedor de mi lista?',
    icon: 'question',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Si, eliminar',
    cancelButtonText: 'No, cancelar'
  }).then((result) => {
    if (result.isConfirmed) {

      $.ajax({
        url : 'BackEnd/Usuarios/vendedor_delete.php',
        data : {'id' : id},
        type : 'POST',
        success : function(response){
          //console.log(response);

          Swal.fire(
            'Listo',
            'Vendedor eliminado exitosamente.',
            'success'
          )
          
          mis_vendedores();
        },
        error : function(error){
          console.log(error);
        }
      });
    }
  })
}