$(function(){
  console.log('formas de contacto is running...');
  catalogo_contacto();
  formasContactoList();

  //Forma de contacto ADD
  $('#idFormUsrContactoAdd').submit(function(e){
    e.preventDefault();

    let idNivel     = $('#idInputUsrContactoAdd_tipo').val();
    let descripcion = $('#idInputUsrContactoAdd_descripcion').val();
    let publico     = $('#idInputUsrContactoAdd_publico').val();
    let prioridad     = $('#idInputUsrContactoAdd_prioridad').val();
    //console.log( idNivel, descripcion);

    formasContactoAdd( idNivel, descripcion, publico, prioridad);
  });
});


function catalogo_contacto() {
  $.ajax({
    url : 'BackEnd/Catalogo_2/list.php',
    data : {'idCatalogo1' : 2},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos);

      let templete = `<option value="">---</option>`;
      datos.forEach(elemento => {
        templete += `
        <option value="${elemento['elemento']['id']}">${elemento['elemento']['nombre']}</option>
        `;
      });
      $('#idInputUsrContactoAdd_tipo').html(templete);
    },
    error : function(error){
      console.log(error); 
    }
  });
}

function formasContactoAdd( idNivel, descripcion, publico, prioridad){
  $.ajax({
    url : 'BackEnd/Usuarios/contacto-add.php',
    data : {
      'idUsr'       : 0,
      'idNivel'     : idNivel,
      'descripcion' : descripcion,
      'publico'     : publico,
      'prioridad'   : prioridad
    },
    type : 'POST',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos);

      $('#idModalUsrContactoAdd').modal('hide');
      $('#idFormUsrContactoAdd').trigger('reset');

      Swal.fire(
        'Listo',
        'Forma de contacto agregada',
        'success'
      )

      formasContactoList();

    },
    error : function(error){
      console.log(error);
    }
  });
}

function formasContactoList() { 

  $.ajax({
    url : 'BackEnd/Usuarios/contacto-list.php',
    data : {'id' : 0},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos);

      let templete = ``;
      let cont = 1;

      datos.forEach(elemento => {
        //console.log(elemento['crud']);
        templete += `
        <tr>
          <th>${cont}</th>
          <td>${elemento['tipo']['icono_fa']} ${elemento['tipo']['nombre']}</td>
          <td>${elemento['contacto']['descripcion']}</td>
          <td>${(elemento['contacto']['publico'] == 1) ? 'Si' : 'No'}</td>
          <td>${elemento['contacto']['prioridad']}</td>`;
        
          //BAJAS
          if(elemento['crud'][0]['crud_pagina']['bajas'] == 1){
            templete += `
            <td>
              <button 
                type="button" 
                class="btn btn-outline-danger btn-sm"
                onclick="formasContactoDelete(${elemento['contacto']['id']}, ${elemento['contacto']['id_usr']})">
                  <i class="far fa-trash-alt"></i>
                </button>
            </td>`;
          } else {
            templete += `
            <td>
            </td>`;
          }

        templete += `
        </tr>
        `;
        cont++;
      });

      $('#idTableBodyUsrContacto').html(templete);
    },
    error : function(error) {
      console.log(error);
    }
  });
}

function formasContactoDelete(id, idUsr) {
  //console.log(id, idUsr);

  Swal.fire({
    title: '¿Estas seguro?',
    text: "¡No podrás revertir esto!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: '¡Si, borrarlo!'
  }).then((result) => {
    if (result.isConfirmed) {

      $.ajax({
        url : 'BackEnd/Usuarios/contacto-delete.php',
        data : {
          'id'      : id,
          'idUsr'   : idUsr
        },
        type : 'POST',
        success : function(response) {
          //console.log(response);
    
          Swal.fire(
            'Listo',
            'Forma de contacto eliminada',
            'success'
          )
          formasContactoList(idUsr);
        },
        error : function(error){
          console.log(error);
        }
      });

      
    }
  })

}
