//Tomamos las variables locales
let idCatalogo1 = localStorage.getItem('idCatalogo1');
let nombreCatalogo1 = localStorage.getItem('nombreCatalogo1');
$('#idInputCatalogo4Add_idCatalogo1').val(idCatalogo1);

let idCatalogo2 = localStorage.getItem('idCatalogo2');
let nombreCatalogo2 = localStorage.getItem('nombreCatalogo2');
$('#idInputCatalogo4Add_idCatalogo2').val(idCatalogo2);

let idCatalogo3 = localStorage.getItem('idCatalogo3');
let nombreCatalogo3 = localStorage.getItem('nombreCatalogo3');
$('#idInputCatalogo4Add_idCatalogo3').val(idCatalogo3);

$(function(){
  //console.log('catalogo 2 is running...');

  //Breadcrumb
  $('#idBreadcrumbCatalogo1').html(nombreCatalogo1+' - <small>(Id.'+idCatalogo1+')</small>');
  $('#idBreadcrumbCatalogo2').html(nombreCatalogo2+' - <small>(Id.'+idCatalogo2+')</small>');
  $('#idBreadcrumbCatalogo3').html(nombreCatalogo3+' - <small>(Id.'+idCatalogo3+')</small>');


  //add catalogo 4
  $('#idFormtCatalogo4Add').submit(function(e){
    e.preventDefault();
    let idCatalogo1 = $('#idInputCatalogo4Add_idCatalogo1').val();
    let idCatalogo2 = $('#idInputCatalogo4Add_idCatalogo2').val();
    let idCatalogo3 = $('#idInputCatalogo4Add_idCatalogo3').val();
    let icono_fa    = $('#idInputCatalogo4Add_icono_fa').val();
    let nombre      = $('#idInputCatalogo4Add_nombre').val();
    let descripcion = $('#idInputCatalogo4Add_descripcion').val();
    //console.log(icono_fa, nombre, descripcion);

    categoria_4_add(idCatalogo1, idCatalogo2, idCatalogo3, icono_fa, nombre, descripcion);
  });

  categoria_4_list(idCatalogo1, idCatalogo2, idCatalogo3);

  //edit catalogo 4
  $('#idFormtCatalogo4Edit').submit(function(e){
    e.preventDefault();
    let id          = $('#idInputCatalogo4Edit_id').val();
    let icono_fa    = $('#idInputCatalogo4Edit_icono_fa').val();
    let nombre      = $('#idInputCatalogo4Edit_nombre').val();
    let descripcion = $('#idInputCatalogo4Edit_descripcion').val();
    //console.log(icono_fa, nombre, descripcion);

    catalogo_4_edit(id, icono_fa, nombre, descripcion);
  });

  //6 id pagina catalogo_4.html en la tabla g13_paginas
  allowCrud(6);
});

function allowCrud(idPagina) {
  //console.log(idPagina);
  $.ajax({
    url : 'BackEnd/Permisos/crud-allow.php',
    data : {'idPagina' : idPagina},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos[0]['crud_pagina']['altas']);

      let templete = ``;

      if(datos[0]['crud_pagina']['altas'] == 1) {
        templete = `
          <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#idModalCatalogo4_Add">
            <i class="fas fa-plus"></i> Nuevo
          </button>`;
      } 
      $('#idDivCat_add').html(templete);

    },
    error : function(error){
      console.log(error);
    }
  });
}


function categoria_4_add(idCatalogo1, idCatalogo2, idCatalogo3, icono_fa, nombre, descripcion){
  console.log(idCatalogo1, idCatalogo2, idCatalogo3, icono_fa, nombre, descripcion)
  $.ajax({
    url : 'BackEnd/Catalogo_4/add.php',
    data : {
      'idCatalogo1' : idCatalogo1,
      'idCatalogo2' : idCatalogo2,
      'idCatalogo3' : idCatalogo3,
      'icono_fa'    : icono_fa,
      'nombre'      : nombre,
      'descripcion' : descripcion
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      Swal.fire(
        'Listo',
        'Catálogo gregado correctamente',
        'success'
      )
      $('#idFormtCatalogo4Add').trigger('reset');
      $('#idModalCatalogo4_Add').modal('hide');

      categoria_4_list(idCatalogo1, idCatalogo2, idCatalogo3);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function categoria_4_list(idCatalogo1, idCatalogo2){
  //console.log('idCatalogo1: '+idCatalogo1);
  $.ajax({
    url : 'BackEnd/Catalogo_4/list.php',
    data : {
      'idCatalogo1' : idCatalogo1, 
      'idCatalogo2' : idCatalogo2,
      'idCatalogo3' : idCatalogo3
    },
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      
      let templete = ``;
      let cont = 1;
      datos.forEach(elemento => {
        // console.log(elemento['crud'][0]['crud_pagina']['altas']);
        // console.log(elemento['crud'][0]['crud_pagina']['bajas']);
        // console.log(elemento['crud'][0]['crud_pagina']['modificaciones']);
        // console.log(elemento['crud'][0]['crud_pagina']['consultas']);

        templete += `
          <tr>
            <th scope="row">${cont}</th>
            <td>${elemento['elemento']['icono_fa']}</td>
            <td>${elemento['elemento']['nombre']}</td>
            <td>${elemento['elemento']['descripcion']}</td>
            <td>`;

        templete += `
              <!--button 
                type="button" 
                class="btn btn-outline-danger btn-sm"
                onclick="catalogo4Delete(${elemento['elemento']['id']})">
                <i class="far fa-trash-alt"></i>
              </button-->`;


        //MODIFICACIONES
        if(elemento['crud'][0]['crud_pagina']['modificaciones'] == 1) {
          templete += `
              <button 
                type="button" 
                class="btn btn-outline-warning btn-sm"
                data-toggle="modal" 
                data-target="#idModalCatalogo4_Edit"
                onclick="modalCatalogo4_Edit(${elemento['elemento']['id']})">
                <i class="far fa-edit"></i>
              </button>`;
        }

        templete += `
            </td>
          </tr>`;
        cont++;
      });
      $('#idTableBodyCatalogos4List').html(templete);
      $('#idTableCatalogos4List').DataTable();
    },
    error : function(error){
      console.log(error);
    }
  });
}

function modalCatalogo4_Edit(id){
  $.ajax({
    url : 'BackEnd/Catalogo_4/single.php',
    data : {'id' : id},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos['elemento']);

      $('#idInputCatalogo4Edit_id').val(id);
      $('#idInputCatalogo4Edit_icono_fa').val(datos['elemento']['icono_fa']);
      $('#idInputCatalogo4Edit_nombre').val(datos['elemento']['nombre']);
      $('#idInputCatalogo4Edit_descripcion').val(datos['elemento']['descripcion']);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function catalogo_4_edit(id, icono_fa, nombre, descripcion){
  $.ajax({
    url : 'BackEnd/Catalogo_4/edit.php',
    data : {
      'id'          : id,
      'icono_fa'    : icono_fa,
      'nombre'      : nombre,
      'descripcion' : descripcion
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      Swal.fire(
        'Listo',
        'Catálogo editado correctamente',
        'success'
      )
      $('#idFormtCatalogo4Edit').trigger('reset');
      $('#idModalCatalogo4_Edit').modal('hide');

      categoria_4_list(idCatalogo1, idCatalogo2, idCatalogo3);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function catalogo4Delete(id){
  Swal.fire({
    title: '¿Estas seguro?',
    text: "¡No podrás revertir esto!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    confirmButtonText: '¡Sí, bórralo!',
    cancelButtonColor: '#d33',
    cancelButtonText: 'No'
  }).then((result) => {
    if (result.isConfirmed) {
      
      $.ajax({
        url : 'BackEnd/Catalogo_4/delete.php',
        data : {'id' : id},
        type : 'POST',
        success : function(response){
          //console.log(response);
    
          Swal.fire(
            'Listo',
            'Catálogo eliminado correctamente',
            'success'
          )
          categoria_4_list(idCatalogo1, idCatalogo2, idCatalogo3);
        },
        error : function(error){
          console.log(error);
        }
      });

    }
  })

}

