//Tomamos las variables locales
let idCatalogo1 = localStorage.getItem('idCatalogo1');
let nombreCatalogo1 = localStorage.getItem('nombreCatalogo1');
$('#idInputCatalogo3Add_idCatalogo1').val(idCatalogo1);

let idCatalogo2 = localStorage.getItem('idCatalogo2');
let nombreCatalogo2 = localStorage.getItem('nombreCatalogo2');
$('#idInputCatalogo3Add_idCatalogo2').val(idCatalogo2);

$(function(){
  //console.log('catalogo 2 is running...');

  //Breadcrumb
  $('#idBreadcrumbCatalogo1').html(nombreCatalogo1+' - <small>(Id.'+idCatalogo1+')</small>');
  $('#idBreadcrumbCatalogo2').html(nombreCatalogo2+' - <small>(Id.'+idCatalogo2+')</small>');

  //add catalogo 3
  $('#idFormtCatalogo3Add').submit(function(e){
    e.preventDefault();
    let idCatalogo1 = $('#idInputCatalogo3Add_idCatalogo1').val();
    let idCatalogo2 = $('#idInputCatalogo3Add_idCatalogo2').val();
    let icono_fa    = $('#idInputCatalogo3Add_icono_fa').val();
    let nombre      = $('#idInputCatalogo3Add_nombre').val();
    let descripcion = $('#idInputCatalogo3Add_descripcion').val();
    //console.log(icono_fa, nombre, descripcion);

    categoria_3_add(idCatalogo1, idCatalogo2, icono_fa, nombre, descripcion);
  });

  categoria_3_list(idCatalogo1, idCatalogo2);

  //edit catalogo 3
  $('#idFormtCatalogo3Edit').submit(function(e){
    e.preventDefault();
    let id          = $('#idInputCatalogo3Edit_id').val();
    let icono_fa    = $('#idInputCatalogo3Edit_icono_fa').val();
    let nombre      = $('#idInputCatalogo3Edit_nombre').val();
    let descripcion = $('#idInputCatalogo3Edit_descripcion').val();
    //console.log(icono_fa, nombre, descripcion);

    catalogo_3_edit(id, icono_fa, nombre, descripcion);
  });

  //5 id pagina catalogo_3.html en la tabla g13_paginas
  allowCrud(5);
});

function allowCrud(idPagina) {
  //console.log(idPagina);
  $.ajax({
    url : 'BackEnd/Permisos/crud-allow.php',
    data : {'idPagina' : idPagina},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos[0]['crud_pagina']['altas']);

      let templete = ``;

      if(datos[0]['crud_pagina']['altas'] == 1) {
        templete = `
          <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#idModalCatalogo3_Add">
            <i class="fas fa-plus"></i> Nuevo
          </button>`;
      } 
      $('#idDivCat_add').html(templete);

    },
    error : function(error){
      console.log(error);
    }
  });
}

function categoria_3_add(idCatalogo1, idCatalogo2, icono_fa, nombre, descripcion){

  $.ajax({
    url : 'BackEnd/Catalogo_3/add.php',
    data : {
      'idCatalogo1' : idCatalogo1,
      'idCatalogo2' : idCatalogo2,
      'icono_fa'    : icono_fa,
      'nombre'      : nombre,
      'descripcion' : descripcion
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      Swal.fire(
        'Listo',
        'Catálogo gregado correctamente',
        'success'
      )
      $('#idFormtCatalogo3Add').trigger('reset');
      $('#idModalCatalogo3_Add').modal('hide');

      categoria_3_list(idCatalogo1, idCatalogo2);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function categoria_3_list(idCatalogo1, idCatalogo2){
  //console.log('idCatalogo1: '+idCatalogo1);
  $.ajax({
    url : 'BackEnd/Catalogo_3/list.php',
    data : {'idCatalogo1' : idCatalogo1, 'idCatalogo2' : idCatalogo2},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);
      
      let templete = ``;
      let cont = 1;
      datos.forEach(elemento => {
        // console.log(elemento['crud'][0]['crud_pagina']['altas']);
        // console.log(elemento['crud'][0]['crud_pagina']['bajas']);
        // console.log(elemento['crud'][0]['crud_pagina']['modificaciones']);
        // console.log(elemento['crud'][0]['crud_pagina']['consultas']);
        templete += `
        <tr>
          <th scope="row">${cont}</th>
          <td>${elemento['elemento']['icono_fa']}</td>
          <td>${elemento['elemento']['nombre']} <small>(Id. ${elemento['elemento']['id']})</small></td>
          <td>${elemento['elemento']['descripcion']}</td>
          <td>
            <!--button 
              type="button" 
              class="btn btn-outline-danger btn-sm"
              onclick="catalogo3Delete(${elemento['elemento']['id']})">
              <i class="far fa-trash-alt"></i>
            </button-->`;

        //MODIFICACIONES
        if(elemento['crud'][0]['crud_pagina']['modificaciones'] == 1) {
          templete += `
            <button 
              type="button" 
              class="btn btn-outline-warning btn-sm"
              data-toggle="modal" 
              data-target="#idModalCatalogo3_Edit"
              onclick="modalCatalogo3_Edit(${elemento['elemento']['id']})">
              <i class="far fa-edit"></i>
            </button>`;
        }

        templete += `
            <button 
              type="button" 
              class="btn btn-outline-info btn-sm"
              onclick="nextCatalogo(${elemento['elemento']['id']}, '${elemento['elemento']['nombre']}')">
              <i class="far fa-arrow-alt-circle-right"></i>
            </button>`;

        templete += `
          </td>
        </tr>
        `;
        cont++;
      });
      $('#idTableBodyCatalogos3List').html(templete);
      $('#idTableCatalogos3List').DataTable();
    },
    error : function(error){
      console.log(error);
    }
  });
}

function modalCatalogo3_Edit(id){
  $.ajax({
    url : 'BackEnd/Catalogo_3/single.php',
    data : {'id' : id},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos['elemento']);

      $('#idInputCatalogo3Edit_id').val(id);
      $('#idInputCatalogo3Edit_icono_fa').val(datos['elemento']['icono_fa']);
      $('#idInputCatalogo3Edit_nombre').val(datos['elemento']['nombre']);
      $('#idInputCatalogo3Edit_descripcion').val(datos['elemento']['descripcion']);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function catalogo_3_edit(id, icono_fa, nombre, descripcion){
  $.ajax({
    url : 'BackEnd/Catalogo_3/edit.php',
    data : {
      'id'          : id,
      'icono_fa'    : icono_fa,
      'nombre'      : nombre,
      'descripcion' : descripcion
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      Swal.fire(
        'Listo',
        'Catálogo editado correctamente',
        'success'
      )
      $('#idFormtCatalogo3Edit').trigger('reset');
      $('#idModalCatalogo3_Edit').modal('hide');

      categoria_3_list(idCatalogo1, idCatalogo2);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function catalogo3Delete(id){
  Swal.fire({
    title: '¿Estas seguro?',
    text: "¡No podrás revertir esto!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    confirmButtonText: '¡Sí, bórralo!',
    cancelButtonColor: '#d33',
    cancelButtonText: 'No'
  }).then((result) => {
    if (result.isConfirmed) {
      
      $.ajax({
        url : 'BackEnd/Catalogo_3/delete.php',
        data : {'id' : id},
        type : 'POST',
        success : function(response){
          //console.log(response);
    
          Swal.fire(
            'Listo',
            'Catálogo eliminado correctamente',
            'success'
          )
          categoria_3_list(idCatalogo1, idCatalogo2);
        },
        error : function(error){
          console.log(error);
        }
      });

    }
  })

}

function nextCatalogo(id, nombre){
  localStorage.setItem('idCatalogo3', id);
  localStorage.setItem('nombreCatalogo3', nombre);
  window.location.href = 'catalogos_4.html';
}