let idCatalogo1 = localStorage.getItem('idCatalogo1');
let nombreCatalogo1 = localStorage.getItem('nombreCatalogo1');
$('#idInputCatalogo2Add_idCatalogo1').val(idCatalogo1);

$(function(){
  //console.log('catalogo 1 is running...');

  
  $('#idBreadcrumbCatalogo1').html(nombreCatalogo1+' - <small>(Id.'+idCatalogo1+')</small>');

  //add catalogo 2
  $('#idFormtCatalogo2Add').submit(function(e){
    e.preventDefault();
    let idCatalogo1 = $('#idInputCatalogo2Add_idCatalogo1').val();
    let icono_fa    = $('#idInputCatalogo2Add_icono_fa').val();
    let nombre      = $('#idInputCatalogo2Add_nombre').val();
    let descripcion = $('#idInputCatalogo2Add_descripcion').val();
    //console.log(icono_fa, nombre, descripcion);

    categoria_2_add(idCatalogo1, icono_fa, nombre, descripcion);
  });

  categoria_2_list(idCatalogo1);

  //edit catalogo 2
  $('#idFormtCatalogo2Edit').submit(function(e){
    e.preventDefault();
    let id          = $('#idInputCatalogo2Edit_id').val();
    let icono_fa    = $('#idInputCatalogo2Edit_icono_fa').val();
    let nombre      = $('#idInputCatalogo2Edit_nombre').val();
    let descripcion = $('#idInputCatalogo2Edit_descripcion').val();
    //console.log(icono_fa, nombre, descripcion);

    catalogo_2_edit(id, icono_fa, nombre, descripcion);
  });

  //4 id pagina catalogo_2.html en la tabla g13_paginas
  allowCrud(4);
});

function allowCrud(idPagina) {
  //console.log(idPagina);
  $.ajax({
    url : 'BackEnd/Permisos/crud-allow.php',
    data : {'idPagina' : idPagina},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos[0]['crud_pagina']['altas']);

      let templete = ``;

      if(datos[0]['crud_pagina']['altas'] == 1) {
        templete = `
          <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#idModalCatalogo2_Add">
            <i class="fas fa-plus"></i> Nuevo
          </button>`;
      } 
      $('#idDivCat_add').html(templete);

    },
    error : function(error){
      console.log(error);
    }
  });
}

function categoria_2_add(idCatalogo1, icono_fa, nombre, descripcion){

  $.ajax({
    url : 'BackEnd/Catalogo_2/add.php',
    data : {
      'idCatalogo1' : idCatalogo1,
      'icono_fa'    : icono_fa,
      'nombre'      : nombre,
      'descripcion' : descripcion
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      Swal.fire(
        'Listo',
        'Catálogo gregado correctamente',
        'success'
      )
      $('#idFormtCatalogo2Add').trigger('reset');
      $('#idModalCatalogo2_Add').modal('hide');

      categoria_2_list(idCatalogo1);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function categoria_2_list(idCatalogo1){
  //console.log('idCatalogo1: '+idCatalogo1);
  $.ajax({
    url : 'BackEnd/Catalogo_2/list.php',
    data : {'idCatalogo1' : idCatalogo1},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);
      
      let templete = ``;
      let cont = 1;
      datos.forEach(elemento => {
        // console.log(elemento['crud'][0]['crud_pagina']['altas']);
        // console.log(elemento['crud'][0]['crud_pagina']['bajas']);
        // console.log(elemento['crud'][0]['crud_pagina']['modificaciones']);
        // console.log(elemento['crud'][0]['crud_pagina']['consultas']);
        templete += `
        <tr>
          <th scope="row">${cont}</th>
          <td>${elemento['elemento']['icono_fa']}</td>
          <td>${elemento['elemento']['nombre']} - <small>(Id.${elemento['elemento']['id']})</small></td>
          <td>${elemento['elemento']['descripcion']}</td>
          <td>
            <!--button 
              type="button" 
              class="btn btn-outline-danger btn-sm"
              onclick="catalogo2Delete(${elemento['elemento']['id']})">
              <i class="far fa-trash-alt"></i>
            </button-->`;


        //MODIFICACIONES
        if(elemento['crud'][0]['crud_pagina']['modificaciones'] == 1) {
          templete += `
            <button 
              type="button" 
              class="btn btn-outline-warning btn-sm"
              data-toggle="modal" 
              data-target="#idModalCatalogo2_Edit"
              onclick="modalCatalogo2_Edit(${elemento['elemento']['id']})">
              <i class="far fa-edit"></i>
            </button>`;
        }


        templete += `
            <button 
              type="button" 
              class="btn btn-outline-info btn-sm"
              onclick="nextCatalogo(${elemento['elemento']['id']}, '${elemento['elemento']['nombre']}')">
              <i class="far fa-arrow-alt-circle-right"></i>
            </button>`;
        
        templete += `
          </td>
        </tr>
        `;
        cont++;
      });
      $('#idTableBodyCatalogos2List').html(templete);
      $('#idTableCatalogos2List').DataTable();
    },
    error : function(error){
      console.log(error);
    }
  });
}

function modalCatalogo2_Edit(id){
  $.ajax({
    url : 'BackEnd/Catalogo_2/single.php',
    data : {'id' : id},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos['elemento']);

      $('#idInputCatalogo2Edit_id').val(id);
      $('#idInputCatalogo2Edit_icono_fa').val(datos['elemento']['icono_fa']);
      $('#idInputCatalogo2Edit_nombre').val(datos['elemento']['nombre']);
      $('#idInputCatalogo2Edit_descripcion').val(datos['elemento']['descripcion']);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function catalogo_2_edit(id, icono_fa, nombre, descripcion){
  $.ajax({
    url : 'BackEnd/Catalogo_2/edit.php',
    data : {
      'id'          : id,
      'icono_fa'    : icono_fa,
      'nombre'      : nombre,
      'descripcion' : descripcion
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      Swal.fire(
        'Listo',
        'Catálogo editado correctamente',
        'success'
      )
      $('#idFormtCatalogo2Edit').trigger('reset');
      $('#idModalCatalogo2_Edit').modal('hide');

      categoria_2_list(idCatalogo1);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function catalogo2Delete(id){
  Swal.fire({
    title: '¿Estas seguro?',
    text: "¡No podrás revertir esto!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    confirmButtonText: '¡Sí, bórralo!',
    cancelButtonColor: '#d33',
    cancelButtonText: 'No'
  }).then((result) => {
    if (result.isConfirmed) {
      
      $.ajax({
        url : 'BackEnd/Catalogo_2/delete.php',
        data : {'id' : id},
        type : 'POST',
        success : function(response){
          //console.log(response);
    
          Swal.fire(
            'Listo',
            'Catálogo eliminado correctamente',
            'success'
          )
          categoria_2_list(idCatalogo1);
        },
        error : function(error){
          console.log(error);
        }
      });

    }
  })

}

function nextCatalogo(id, nombre){
  localStorage.setItem('idCatalogo2', id);
  localStorage.setItem('nombreCatalogo2', nombre);
  window.location.href = 'catalogos_3.html';
}