$(function(){
  console.log('catalogo 1 is running...');

  //add catalogo 1
  $('#idFormtCatalogo1Add').submit(function(e){
    e.preventDefault();
    let icono_fa    = $('#idInputCatalogo1Add_icono_fa').val();
    let nombre      = $('#idInputCatalogo1Add_nombre').val();
    let descripcion = $('#idInputCatalogo1Add_descripcion').val();
    //console.log(icono_fa, nombre, descripcion);

    categoria_1_add(icono_fa, nombre, descripcion);
  });

  categoria_1_list();

  //edit catalogo 1
  $('#idFormtCatalogo1Edit').submit(function(e){
    e.preventDefault();
    let id          = $('#idInputCatalogo1Edit_id').val();
    let icono_fa    = $('#idInputCatalogo1Edit_icono_fa').val();
    let nombre      = $('#idInputCatalogo1Edit_nombre').val();
    let descripcion = $('#idInputCatalogo1Edit_descripcion').val();
    //console.log(icono_fa, nombre, descripcion);

    catelogo_1_edit(id, icono_fa, nombre, descripcion);
  });

  //3 id pagina catalogo_1.html en la tabla g13_paginas
  allowCrud(3);
});

function allowCrud(idPagina) {
  //console.log(idPagina);
  $.ajax({
    url : 'BackEnd/Permisos/crud-allow.php',
    data : {'idPagina' : idPagina},
    type : 'GET',
    success : function(response) {
      let datos = JSON.parse(response);
      //console.log(datos[0]['crud_pagina']['altas']);

      let templete = ``;

      if(datos[0]['crud_pagina']['altas'] == 1) {
        templete = `
          <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#idModalCatalogo1_Add">
            <i class="fas fa-plus"></i> Nuevo
          </button>`;
      } 
      $('#idDivCat_add').html(templete);

    },
    error : function(error){
      console.log(error);
    }
  });
}

function categoria_1_add(icono_fa, nombre, descripcion){
  $.ajax({
    url : 'BackEnd/Catalogo_1/add.php',
    data : {
      'icono_fa'    : icono_fa,
      'nombre'      : nombre,
      'descripcion' : descripcion
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      Swal.fire(
        'Listo',
        'Catálogo gregado correctamente',
        'success'
      )
      $('#idFormtCatalogo1Add').trigger('reset');
      $('#idModalCatalogo1_Add').modal('hide');

      categoria_1_list();

    },
    error : function(error){
      console.log(error);
    }
  });
}

function categoria_1_list(){
  $.ajax({
    url : 'BackEnd/Catalogo_1/list.php',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos);

      let templete = ``;
      let cont = 1;
      datos.forEach(catalogo_1 => {
        // console.log(catalogo_1['crud'][0]['crud_pagina']['altas']);
        // console.log(catalogo_1['crud'][0]['crud_pagina']['bajas']);
        // console.log(catalogo_1['crud'][0]['crud_pagina']['modificaciones']);
        // console.log(catalogo_1['crud'][0]['crud_pagina']['consultas']);
        templete += `
        <tr>
          <th scope="row">${cont}</th>
          <td>${catalogo_1['catalogo_1']['icono_fa']}</td>
          <td>${catalogo_1['catalogo_1']['nombre']} - <small>(Id.${catalogo_1['catalogo_1']['id']})</small></td>
          <td>${catalogo_1['catalogo_1']['descripcion']}</td>
          <td>
            <!--button 
              type="button" 
              class="btn btn-outline-danger btn-sm"
              onclick="catalogo1Delete(${catalogo_1['catalogo_1']['id']})">
              <i class="far fa-trash-alt"></i>
            </button-->`;

        //MODIFICACIONES
        if(catalogo_1['crud'][0]['crud_pagina']['modificaciones'] == 1) {
          templete += `
            <button 
              type="button" 
              class="btn btn-outline-warning btn-sm"
              data-toggle="modal" 
              data-target="#idModalCatalogo1_Edit"
              onclick="modalCatalogo1Edit(${catalogo_1['catalogo_1']['id']})">
              <i class="far fa-edit"></i>
            </button>`;
        }

        templete += `
            <button 
              type="button" 
              class="btn btn-outline-info btn-sm"
              onclick="nextCatalogo(${catalogo_1['catalogo_1']['id']}, '${catalogo_1['catalogo_1']['nombre']}')">
              <i class="far fa-arrow-alt-circle-right"></i>
            </button>`;

        templete += `
          </td>
        </tr>
        `;
        cont++;
      });
      $('#idTableBodyCatalogos1List').html(templete);
      $('#idTableCatalogos1List').DataTable();
      
    },
    error : function(error){
      console.log(error);
    }
  });
}

function modalCatalogo1Edit(id){
  $.ajax({
    url : 'BackEnd/Catalogo_1/single.php',
    data : {'id' : id},
    type : 'GET',
    success : function(response){
      let datos = JSON.parse(response);
      //console.log(datos['elemento']);

      $('#idInputCatalogo1Edit_id').val(id);
      $('#idInputCatalogo1Edit_icono_fa').val(datos['elemento']['icono_fa']);
      $('#idInputCatalogo1Edit_nombre').val(datos['elemento']['nombre']);
      $('#idInputCatalogo1Edit_descripcion').val(datos['elemento']['descripcion']);
    },
    error : function(error){
      console.log(error);
    }
  });
}

function catelogo_1_edit(id, icono_fa, nombre, descripcion){
  $.ajax({
    url : 'BackEnd/Catalogo_1/edit.php',
    data : {
      'id'          : id,
      'icono_fa'    : icono_fa,
      'nombre'      : nombre,
      'descripcion' : descripcion
    },
    type : 'POST',
    success : function(response){
      let datos = JSON.parse(response);
      console.log(datos);

      Swal.fire(
        'Listo',
        'Catálogo editado correctamente',
        'success'
      )
      $('#idFormtCatalogo1Edit').trigger('reset');
      $('#idModalCatalogo1_Edit').modal('hide');

      categoria_1_list();
    },
    error : function(error){
      console.log(error);
    }
  });
}

function catalogo1Delete(id){

  Swal.fire({
    title: '¿Estas seguro?',
    text: "¡No podrás revertir esto!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    confirmButtonText: '¡Sí, bórralo!',
    cancelButtonColor: '#d33',
    cancelButtonText: 'No'
  }).then((result) => {
    if (result.isConfirmed) {
      
      $.ajax({
        url : 'BackEnd/Catalogo_1/delete.php',
        data : {'id' : id},
        type : 'POST',
        success : function(response){
          //console.log(response);
    
          Swal.fire(
            'Listo',
            'Catálogo eliminado correctamente',
            'success'
          )
          categoria_1_list();
        },
        error : function(error){
          console.log(error);
        }
      });

    }
  })

}

function nextCatalogo(id, nombre){
  localStorage.setItem('idCatalogo1', id);
  localStorage.setItem('nombreCatalogo1', nombre);
  window.location.href = 'catalogos_2.html';
}